/*
 * Decompiled with CFR 0.152.
 */
package internal;

import internal.RGB;
import java.awt.Color;
import lombok.Generated;
import lombok.NonNull;

public final class Colors {
    @NonNull
    public static Color withAlpha(@NonNull Color c, int alpha) {
        if (c == null) {
            throw new NullPointerException("c is marked non-null but is null");
        }
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    @NonNull
    public static Color blend(@NonNull Color from, @NonNull Color to, double ratio) {
        if (from == null) {
            throw new NullPointerException("from is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        return Colors.rgbToColor(RGB.blend(from.getRGB(), to.getRGB(), ratio));
    }

    public static double getLuminance(Color c) {
        return RGB.getLuminance(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static boolean isDark(Color color) {
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        return RGB.isDark(r, g, b);
    }

    @NonNull
    public static Color rgbToColor(int value) {
        return new Color(value, false);
    }

    public static int colorToRgb(@NonNull Color color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return RGB.rgb(color.getRed(), color.getGreen(), color.getBlue());
    }

    @NonNull
    public static String toHex(@NonNull Color color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return RGB.toHex(color.getRed(), color.getGreen(), color.getBlue());
    }

    @NonNull
    public static Color toGray(@NonNull Color color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        return Colors.rgbToColor(RGB.toGray(Colors.colorToRgb(color)));
    }

    @Generated
    private Colors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

