/*
 * Decompiled with CFR 0.152.
 */
package internal;

import internal.FontIcon;
import java.awt.Font;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import lombok.Generated;
import lombok.NonNull;

public final class InternalUtil {
    public static final Supplier<Icon> MISSING_ICON = InternalUtil.getLazyResource(InternalUtil::createFallbackIcon);

    @NonNull
    public static Font resizeByFactor(@NonNull Font font, float factor) {
        if (font == null) {
            throw new NullPointerException("font is marked non-null but is null");
        }
        return font.deriveFont(font.getSize2D() * factor);
    }

    @NonNull
    public static <X> Supplier<X> getLazyResource(@NonNull Supplier<X> factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return new LazyResource<X>(InternalUtil.withUpdateUI(factory));
    }

    @NonNull
    private static <X> Supplier<X> withUpdateUI(@NonNull Supplier<X> factory) {
        if (factory == null) {
            throw new NullPointerException("factory is marked non-null but is null");
        }
        return () -> {
            Object result = factory.get();
            if (result instanceof JComponent) {
                UIManager.addPropertyChangeListener(evt -> ((JComponent)result).updateUI());
            }
            return result;
        };
    }

    private static Icon createFallbackIcon() {
        return FontIcon.of('?', new JLabel().getFont(), null, 0.0);
    }

    @Generated
    private InternalUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class LazyResource<X>
    implements Supplier<X> {
        @NonNull
        private final Supplier<X> factory;
        private final AtomicReference<X> resource = new AtomicReference();

        @Override
        public X get() {
            X result = this.resource.get();
            if (result == null) {
                result = this.factory.get();
                this.resource.set(result);
            }
            return result;
        }

        @Generated
        public LazyResource(@NonNull Supplier<X> factory) {
            if (factory == null) {
                throw new NullPointerException("factory is marked non-null but is null");
            }
            this.factory = factory;
        }
    }
}

