/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion;

import ec.util.completion.AutoCompletionSource;
import ec.util.completion.AutoCompletionSources;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import lombok.NonNull;

public abstract class ExtAutoCompletionSource
implements AutoCompletionSource {
    @NonNull
    public abstract Request getRequest(@NonNull String var1);

    @NonNull
    public static Request wrap(@NonNull AutoCompletionSource source, @NonNull String term) {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        Objects.requireNonNull(source);
        return new BasicRequest(term, () -> source.getBehavior(term), () -> source.getValues(term));
    }

    @NonNull
    public static <T> Builder<T> builder(@NonNull Callable<List<T>> supplier) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        return ExtAutoCompletionSource.builder((String o) -> (List)supplier.call());
    }

    @NonNull
    public static <T> Builder<T> builder(@NonNull Loader<T> loader) {
        if (loader == null) {
            throw new NullPointerException("loader is marked non-null but is null");
        }
        return new BuilderImpl<T>(loader);
    }

    @NonNull
    public static Predicate<String> basicFilter(@NonNull String term) {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        String normalizedTerm = AutoCompletionSources.normalize(term);
        return value -> value != null && !value.isEmpty() && AutoCompletionSources.normalize(value).contains(normalizedTerm);
    }

    private static final class BasicRequest
    extends Request {
        private final String term;
        private final Supplier<AutoCompletionSource.Behavior> behavior;
        private final Callable<List<?>> callable;

        public BasicRequest(@NonNull String term, @NonNull Supplier<AutoCompletionSource.Behavior> behavior, @NonNull Callable<List<?>> callable) {
            this.term = Objects.requireNonNull(term);
            this.behavior = Objects.requireNonNull(behavior);
            this.callable = Objects.requireNonNull(callable);
        }

        @Override
        @NonNull
        public String getTerm() {
            return this.term;
        }

        @Override
        @NonNull
        public AutoCompletionSource.Behavior getBehavior() {
            return this.behavior.get();
        }

        @Override
        public List<?> call() throws Exception {
            return this.callable.call();
        }
    }

    public static interface Loader<T> {
        @NonNull
        public List<T> load(@NonNull String var1) throws Exception;
    }

    public static interface Builder<T> {
        @NonNull
        public Builder<T> postProcessor(@NonNull BiFunction<List<T>, String, List<T>> var1);

        @NonNull
        public Builder<T> behavior(@NonNull Function<? super String, AutoCompletionSource.Behavior> var1);

        @NonNull
        default public Builder<T> behavior(@NonNull AutoCompletionSource.Behavior behavior) {
            Objects.requireNonNull(behavior);
            return this.behavior((? super String o) -> behavior);
        }

        @NonNull
        public Builder<T> valueToString(@NonNull Function<T, String> var1);

        @NonNull
        public Builder<T> cache(@NonNull ConcurrentMap var1, @NonNull Function<? super String, Object> var2, @NonNull Function<? super String, AutoCompletionSource.Behavior> var3);

        @NonNull
        default public Builder<T> cache(@NonNull ConcurrentMap cache, @NonNull Function<? super String, Object> toKey, @NonNull AutoCompletionSource.Behavior behavior) {
            if (cache == null) {
                throw new NullPointerException("cache is marked non-null but is null");
            }
            if (toKey == null) {
                throw new NullPointerException("toKey is marked non-null but is null");
            }
            Objects.requireNonNull(behavior);
            return this.cache(cache, toKey, (? super String o) -> behavior);
        }

        @NonNull
        public ExtAutoCompletionSource build();
    }

    private static final class BuilderImpl<T>
    implements Builder<T> {
        private final Loader<T> loader;
        private BiFunction<List<T>, String, List<T>> processor;
        private Function<? super String, AutoCompletionSource.Behavior> behavior;
        private Function<T, String> toString;
        private ConcurrentMap cache;
        private Function<? super String, Object> toKey;
        private Function<? super String, AutoCompletionSource.Behavior> cacheBehavior;

        public BuilderImpl(Loader<T> loader) {
            this.loader = loader;
            this.processor = (values, term) -> values;
            this.behavior = o -> AutoCompletionSource.Behavior.ASYNC;
            this.toString = Object::toString;
            this.cache = null;
            this.toKey = null;
            this.cacheBehavior = null;
        }

        @Override
        @NonNull
        public Builder<T> postProcessor(@NonNull BiFunction<List<T>, String, List<T>> processor) {
            this.processor = Objects.requireNonNull(processor);
            return this;
        }

        @Override
        @NonNull
        public Builder<T> behavior(@NonNull Function<? super String, AutoCompletionSource.Behavior> behavior) {
            this.behavior = Objects.requireNonNull(behavior);
            return this;
        }

        @Override
        @NonNull
        public Builder<T> valueToString(@NonNull Function<T, String> toString) {
            this.toString = Objects.requireNonNull(toString);
            return this;
        }

        @Override
        @NonNull
        public Builder<T> cache(@NonNull ConcurrentMap cache, @NonNull Function<? super String, Object> toKey, @NonNull Function<? super String, AutoCompletionSource.Behavior> behavior) {
            this.cache = Objects.requireNonNull(cache);
            this.toKey = Objects.requireNonNull(toKey);
            this.cacheBehavior = Objects.requireNonNull(behavior);
            return this;
        }

        @Override
        @NonNull
        public ExtAutoCompletionSource build() {
            return this.cache != null ? new CachedExtAutoCompletionSource<T>(this.loader, this.processor, this.behavior, this.toString, this.cache, this.toKey, this.cacheBehavior) : new DefaultExtAutoCompletionSource<T>(this.loader, this.processor, this.behavior, this.toString);
        }
    }

    private static final class CachedExtAutoCompletionSource<T>
    extends ExtAutoCompletionSource {
        private final Loader<T> loader;
        private final BiFunction<List<T>, String, List<T>> processor;
        private final Function<? super String, AutoCompletionSource.Behavior> behavior;
        private final Function<T, String> toString;
        private final ConcurrentMap cache;
        private final Function<? super String, Object> toKey;
        private final Function<? super String, AutoCompletionSource.Behavior> cacheBehavior;

        public CachedExtAutoCompletionSource(Loader<T> loader, BiFunction<List<T>, String, List<T>> consumer, Function<? super String, AutoCompletionSource.Behavior> behavior, Function<T, String> toString, ConcurrentMap cache, Function<? super String, Object> toKey, Function<? super String, AutoCompletionSource.Behavior> cacheBehavior) {
            this.loader = loader;
            this.processor = consumer;
            this.behavior = behavior;
            this.toString = toString;
            this.cache = cache;
            this.toKey = toKey;
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        @NonNull
        public Request getRequest(@NonNull String term) {
            if (term == null) {
                throw new NullPointerException("term is marked non-null but is null");
            }
            Object key = this.toKey.apply(term);
            List values = (List)this.cache.get(key);
            if (values == null) {
                return new BasicRequest(term, () -> this.behavior.apply(term), () -> {
                    List<T> data = this.loader.load(term);
                    this.cache.put(key, data);
                    return this.processor.apply(data, term);
                });
            }
            return new BasicRequest(term, () -> this.cacheBehavior.apply(term), () -> this.processor.apply(values, term));
        }

        @Override
        @NonNull
        public AutoCompletionSource.Behavior getBehavior(@NonNull String term) {
            if (term == null) {
                throw new NullPointerException("term is marked non-null but is null");
            }
            return this.behavior.apply(term);
        }

        @Override
        @NonNull
        public String toString(@NonNull Object value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return this.toString.apply(value);
        }

        @Override
        @NonNull
        public List<?> getValues(@NonNull String term) throws Exception {
            if (term == null) {
                throw new NullPointerException("term is marked non-null but is null");
            }
            Object key = this.toKey.apply(term);
            List<T> values = (List<T>)this.cache.get(key);
            if (values == null) {
                values = this.loader.load(term);
                this.cache.put(key, values);
            }
            return this.processor.apply(values, term);
        }
    }

    private static final class DefaultExtAutoCompletionSource<T>
    extends ExtAutoCompletionSource {
        private final Loader<T> loader;
        private final BiFunction<List<T>, String, List<T>> processor;
        private final Function<? super String, AutoCompletionSource.Behavior> behavior;
        private final Function<T, String> toString;

        public DefaultExtAutoCompletionSource(Loader<T> loader, BiFunction<List<T>, String, List<T>> consumer, Function<? super String, AutoCompletionSource.Behavior> behavior, Function<T, String> toString) {
            this.loader = loader;
            this.processor = consumer;
            this.behavior = behavior;
            this.toString = toString;
        }

        @Override
        @NonNull
        public Request getRequest(@NonNull String term) {
            if (term == null) {
                throw new NullPointerException("term is marked non-null but is null");
            }
            return new BasicRequest(term, () -> this.behavior.apply(term), () -> this.processor.apply(this.loader.load(term), term));
        }

        @Override
        @NonNull
        public AutoCompletionSource.Behavior getBehavior(@NonNull String term) {
            if (term == null) {
                throw new NullPointerException("term is marked non-null but is null");
            }
            return this.behavior.apply(term);
        }

        @Override
        @NonNull
        public String toString(@NonNull Object value) {
            if (value == null) {
                throw new NullPointerException("value is marked non-null but is null");
            }
            return this.toString.apply(value);
        }

        @Override
        @NonNull
        public List<?> getValues(@NonNull String term) throws Exception {
            if (term == null) {
                throw new NullPointerException("term is marked non-null but is null");
            }
            return this.processor.apply(this.loader.load(term), term);
        }
    }

    public static abstract class Request
    implements Callable<List<?>> {
        @NonNull
        public abstract String getTerm();

        @NonNull
        public abstract AutoCompletionSource.Behavior getBehavior();
    }
}

