/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion;

import ec.util.completion.AutoCompletionSource;
import ec.util.completion.AutoCompletionSources;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;

public class FileAutoCompletionSource
implements AutoCompletionSource {
    protected final boolean strict;
    protected final FileFilter fileFilter;
    protected final File[] paths;

    public FileAutoCompletionSource() {
        this(false, null, new File[0]);
    }

    public FileAutoCompletionSource(boolean strict, FileFilter fileFilter, File[] paths) {
        this.strict = strict;
        this.fileFilter = fileFilter;
        this.paths = paths;
    }

    @Override
    @NonNull
    public AutoCompletionSource.Behavior getBehavior(@NonNull String term) {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        return AutoCompletionSource.Behavior.ASYNC;
    }

    @Override
    @NonNull
    public String toString(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return ((File)value).getPath();
    }

    @NonNull
    public List<File> getValues(@NonNull String term) throws IOException {
        if (term == null) {
            throw new NullPointerException("term is marked non-null but is null");
        }
        if (term.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Path file = Paths.get(term, new String[0]);
            if (Files.exists(file, new LinkOption[0]) && Files.isDirectory(file, new LinkOption[0])) {
                return FileAutoCompletionSource.children(file.toFile(), this.fileFilter);
            }
            Path parent = file.getParent();
            if (parent != null && Files.exists(parent, new LinkOption[0])) {
                return FileAutoCompletionSource.children(parent.toFile(), this.normalizedFilter(term));
            }
        }
        catch (InvalidPathException ex) {
            return Collections.emptyList();
        }
        try {
            for (File path : this.paths) {
                Path file = path.toPath().resolve(term);
                if (Files.exists(file, new LinkOption[0]) && Files.isDirectory(file, new LinkOption[0])) {
                    return this.toRelativeFiles(FileAutoCompletionSource.children(file.toFile(), this.fileFilter), path);
                }
                Path parent = file.getParent();
                if (parent == null || !Files.exists(parent, new LinkOption[0])) continue;
                return this.toRelativeFiles(FileAutoCompletionSource.children(parent.toFile(), this.normalizedFilter(file.toFile().getAbsolutePath())), path);
            }
        }
        catch (InvalidPathException ex) {
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }

    List<File> toRelativeFiles(List<File> files, File path) {
        files.replaceAll(file -> Paths.get(file.getPath().substring(path.getPath().length() + 1), new String[0]).toFile());
        return files;
    }

    FileFilter normalizedFilter(String term) {
        String normalizedTerm = this.getNormalizedString(term);
        return o -> (this.fileFilter == null || this.fileFilter.accept(o)) && this.getNormalizedString(o.getPath()).startsWith(normalizedTerm);
    }

    String getNormalizedString(String input) {
        return this.strict ? input : AutoCompletionSources.normalize(input);
    }

    static List<File> children(File folder, FileFilter fileFilter) {
        Object[] result = folder.listFiles(fileFilter);
        if (result == null) {
            return Collections.emptyList();
        }
        Arrays.sort(result);
        return Arrays.asList(result);
    }
}

