/*
 * Decompiled with CFR 0.152.
 */
package ec.util.completion.swing;

import ec.util.completion.AutoCompletionSources;
import ec.util.completion.swing.CustomListModel;
import java.awt.Component;
import java.util.function.Function;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public class CustomListCellRenderer<T>
extends DefaultListCellRenderer {
    private final boolean highlightTerm;

    @NonNull
    public static <T> DefaultListCellRenderer of(final @NonNull Function<T, String> toValueAsString, final @NonNull Function<T, String> toToolTipText) {
        if (toValueAsString == null) {
            throw new NullPointerException("toValueAsString is marked non-null but is null");
        }
        if (toToolTipText == null) {
            throw new NullPointerException("toToolTipText is marked non-null but is null");
        }
        return new CustomListCellRenderer<T>(){

            @Override
            @NonNull
            protected String getValueAsString(@NonNull T value) {
                if (value == null) {
                    throw new NullPointerException("value is marked non-null but is null");
                }
                return (String)toValueAsString.apply(value);
            }

            @Override
            protected String toToolTipText(String term, JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
                return (String)toToolTipText.apply(value);
            }
        };
    }

    public CustomListCellRenderer() {
        this(true);
    }

    public CustomListCellRenderer(boolean highlightTerm) {
        this.highlightTerm = highlightTerm;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        String term = list.getModel() instanceof CustomListModel ? ((CustomListModel)list.getModel()).getTerm() : null;
        this.setText(this.toString(term, list, value, index, isSelected, cellHasFocus));
        this.setIcon(this.toIcon(term, list, value, index, isSelected, cellHasFocus));
        this.setToolTipText(this.toToolTipText(term, list, value, index, isSelected, cellHasFocus));
        return result;
    }

    protected @Nullable String toString(String term, JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        String valueAsString = this.getValueAsString(value);
        if (!this.highlightTerm || term == null || term.isEmpty()) {
            return valueAsString;
        }
        int beginIndex = this.getNormalizedString(valueAsString).indexOf(this.getNormalizedString(term));
        if (beginIndex == -1) {
            return valueAsString;
        }
        int endIndex = beginIndex + term.length();
        return "<html>" + valueAsString.substring(0, beginIndex) + "<b>" + valueAsString.substring(beginIndex, endIndex) + "</b>" + valueAsString.substring(endIndex);
    }

    protected @Nullable Icon toIcon(String term, JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        return null;
    }

    protected @Nullable String toToolTipText(String term, JList list, T value, int index, boolean isSelected, boolean cellHasFocus) {
        return null;
    }

    @NonNull
    protected String getValueAsString(@NonNull T value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return value.toString();
    }

    @NonNull
    protected String getNormalizedString(@NonNull String input) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        return AutoCompletionSources.normalize(input);
    }
}

