/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import ec.util.various.swing.ModernUI;
import internal.Colors;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.TransferHandler;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class BasicFileViewer
extends JPanel {
    public static final String STATE_PROPERTY = "state";
    public static final String FILE_HANDLER_PROPERTY = "fileHandler";
    public static final String FILE_PROPERTY = "file";
    public static final String START_RENDERER_PROPERTY = "startRenderer";
    public static final String DRAG_RENDERER_PROPERTY = "dragRenderer";
    public static final String LOAD_RENDERER_PROPERTY = "loadRenderer";
    public static final String FAILURE_RENDERER_PROPERTY = "failureRenderer";
    private Component viewer = null;
    private State state = State.READY;
    private BasicFileHandler fileHandler = null;
    private File file = null;
    private StartRenderer startRenderer = DefaultStartRenderer.INSTANCE;
    private DragRenderer dragRenderer = DefaultDragRenderer.INSTANCE;
    private LoadRenderer loadRenderer = DefaultLoadRenderer.INSTANCE;
    private FailureRenderer failureRenderer = DefaultFailureRenderer.INSTANCE;
    private DropTargetDragEvent dragEvent;
    private Throwable cause;
    private static final DataFlavor FILE_DATA_FLAVOR = BasicFileViewer.newLocalObjectDataFlavor(File.class);

    public BasicFileViewer() {
        this.setTransferHandler(new FileTransferHandler());
        try {
            this.getDropTarget().addDropTargetListener(new DropTargetAdapter(){
                State saved;

                @Override
                public void dragEnter(DropTargetDragEvent dtde) {
                    if (BasicFileViewer.this.state != State.LOADING) {
                        BasicFileViewer.this.dragEvent = dtde;
                        this.saved = BasicFileViewer.this.state;
                        BasicFileViewer.this.setState(State.DRAGGING);
                    }
                }

                @Override
                public void dragExit(DropTargetEvent dte) {
                    if (BasicFileViewer.this.state != State.LOADING) {
                        BasicFileViewer.this.setState(this.saved);
                    }
                }

                @Override
                public void drop(DropTargetDropEvent dtde) {
                    this.dragExit(dtde);
                }
            });
        }
        catch (TooManyListenersException ex) {
            Logger.getLogger(BasicFileViewer.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "state": {
                    this.onStateChange();
                    break;
                }
                case "fileHandler": {
                    this.onFileHandlerChange();
                    break;
                }
                case "file": {
                    this.onFileChange();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.startRenderer.getStartComponent(), "Center");
    }

    private void onStateChange() {
        switch (this.state.ordinal()) {
            case 4: {
                this.switchToComponent(this.dragRenderer.getDragComponent(this.dragEvent));
                break;
            }
            case 3: {
                this.switchToComponent(this.failureRenderer.getFailureComponent(this.file, this.cause));
                break;
            }
            case 2: {
                this.switchToComponent(this.viewer);
                break;
            }
            case 1: {
                this.switchToComponent(this.loadRenderer.getLoadComponent(this.file, -1));
                this.recycleViewer();
                break;
            }
            case 0: {
                this.switchToComponent(this.startRenderer.getStartComponent());
                this.recycleViewer();
            }
        }
    }

    private void onFileHandlerChange() {
    }

    private void onFileChange() {
        if (this.file == null) {
            this.setState(State.READY);
            return;
        }
        if (this.fileHandler == null || !this.fileHandler.accept(this.file) || this.state == State.LOADING) {
            return;
        }
        this.setState(State.LOADING);
        new SwingWorker<Object, Integer>(){

            @Override
            protected Object doInBackground() throws Exception {
                return BasicFileViewer.this.fileHandler.asyncLoad(BasicFileViewer.this.file, (min, max, value) -> this.publish((value - min) * 100 / (max - min)));
            }

            @Override
            protected void process(List<Integer> chunks) {
                if (!chunks.isEmpty()) {
                    BasicFileViewer.this.switchToComponent(BasicFileViewer.this.loadRenderer.getLoadComponent(BasicFileViewer.this.file, chunks.get(chunks.size() - 1)));
                }
            }

            @Override
            protected void done() {
                try {
                    BasicFileViewer.this.viewer = BasicFileViewer.this.fileHandler.borrowViewer(this.get());
                    if (BasicFileViewer.this.viewer instanceof JComponent) {
                        ((JComponent)BasicFileViewer.this.viewer).setTransferHandler(null);
                    }
                    BasicFileViewer.this.cause = null;
                    BasicFileViewer.this.setState(State.LOADED);
                }
                catch (InterruptedException ex) {
                    BasicFileViewer.this.cause = ex;
                    BasicFileViewer.this.setState(State.FAILED);
                }
                catch (ExecutionException ex) {
                    BasicFileViewer.this.cause = ex.getCause();
                    BasicFileViewer.this.setState(State.FAILED);
                }
            }
        }.execute();
    }

    private void setState(State state) {
        State old = this.state;
        this.state = state;
        this.firePropertyChange(STATE_PROPERTY, (Object)old, (Object)this.state);
    }

    public BasicFileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(BasicFileHandler fileHandler) {
        BasicFileHandler old = this.fileHandler;
        this.fileHandler = fileHandler;
        this.firePropertyChange(FILE_HANDLER_PROPERTY, old, this.fileHandler);
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        File old = this.file;
        this.file = file;
        this.firePropertyChange(FILE_PROPERTY, old, this.file);
    }

    @NonNull
    public StartRenderer getStartRenderer() {
        return this.startRenderer;
    }

    public void setStartRenderer(@Nullable StartRenderer startRenderer) {
        StartRenderer old = this.startRenderer;
        this.startRenderer = startRenderer != null ? startRenderer : DefaultStartRenderer.INSTANCE;
        this.firePropertyChange(START_RENDERER_PROPERTY, old, this.startRenderer);
    }

    @NonNull
    public DragRenderer getDragRenderer() {
        return this.dragRenderer;
    }

    public void setDragRenderer(@Nullable DragRenderer dragRenderer) {
        DragRenderer old = this.dragRenderer;
        this.dragRenderer = dragRenderer != null ? dragRenderer : DefaultDragRenderer.INSTANCE;
        this.firePropertyChange(DRAG_RENDERER_PROPERTY, old, this.dragRenderer);
    }

    @NonNull
    public LoadRenderer getLoadRenderer() {
        return this.loadRenderer;
    }

    public void setLoadRenderer(@Nullable LoadRenderer loadRenderer) {
        LoadRenderer old = this.loadRenderer;
        this.loadRenderer = loadRenderer != null ? loadRenderer : DefaultLoadRenderer.INSTANCE;
        this.firePropertyChange(LOAD_RENDERER_PROPERTY, old, this.loadRenderer);
    }

    @NonNull
    public FailureRenderer getFailureRenderer() {
        return this.failureRenderer;
    }

    public void setFailureRenderer(@Nullable FailureRenderer failureRenderer) {
        FailureRenderer old = this.failureRenderer;
        this.failureRenderer = failureRenderer != null ? failureRenderer : DefaultFailureRenderer.INSTANCE;
        this.firePropertyChange(FAILURE_RENDERER_PROPERTY, old, this.failureRenderer);
    }

    private void switchToComponent(Component c) {
        this.removeAll();
        if (c != null) {
            this.add(c, "Center");
            this.validate();
            this.invalidate();
            this.repaint();
            c.setSize(this.getSize());
        }
    }

    private void recycleViewer() {
        if (this.viewer != null && this.fileHandler.isViewer(this.viewer)) {
            this.fileHandler.recycleViewer(this.viewer);
            this.viewer = null;
        }
    }

    private static File getSingleFile(Transferable t) {
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            try {
                List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                if (files.size() == 1) {
                    return (File)files.get(0);
                }
            }
            catch (UnsupportedFlavorException | IOException exception) {}
        } else if (t.isDataFlavorSupported(FILE_DATA_FLAVOR)) {
            try {
                return (File)t.getTransferData(FILE_DATA_FLAVOR);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static DataFlavor newLocalObjectDataFlavor(Class<?> clazz) {
        try {
            return new DataFlavor("application/x-java-jvm-local-objectref;class=" + clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static interface LoadRenderer {
        public static final int NO_PROGRESS = -1;

        public Component getLoadComponent(File var1, int var2);
    }

    public static interface BasicFileHandler
    extends FileFilter {
        public Object asyncLoad(File var1, ProgressCallback var2) throws Exception;

        public boolean isViewer(Component var1);

        public Component borrowViewer(Object var1);

        public void recycleViewer(Component var1);
    }

    public static enum State {
        READY,
        LOADING,
        LOADED,
        FAILED,
        DRAGGING;

    }

    private static final class DefaultStartRenderer
    implements StartRenderer {
        public static final DefaultStartRenderer INSTANCE = new DefaultStartRenderer();
        private final JLabel component = new JLabel();

        private DefaultStartRenderer() {
            JList resource = new JList();
            this.component.setOpaque(true);
            this.component.setHorizontalAlignment(0);
            this.component.setFont(resource.getFont().deriveFont(resource.getFont().getSize2D() * 2.0f));
            this.component.setBackground(resource.getBackground());
            this.component.setForeground(Colors.withAlpha(resource.getForeground(), 100));
            this.component.setText("Drop file here");
        }

        @Override
        public Component getStartComponent() {
            return this.component;
        }
    }

    public static interface StartRenderer {
        public Component getStartComponent();
    }

    private static final class DefaultDragRenderer
    implements DragRenderer {
        public static final DefaultDragRenderer INSTANCE = new DefaultDragRenderer();
        private final JLabel component = new JLabel();

        private DefaultDragRenderer() {
            JList resource = new JList();
            this.component.setOpaque(true);
            this.component.setHorizontalAlignment(0);
            this.component.setFont(resource.getFont().deriveFont(resource.getFont().getSize2D() * 2.0f));
            this.component.setBackground(Colors.withAlpha(resource.getSelectionBackground(), 200));
            this.component.setForeground(resource.getSelectionForeground());
            this.component.setBorder(ModernUI.createDropBorder(resource.getSelectionForeground()));
            this.component.setText("Drop file here");
        }

        @Override
        public Component getDragComponent(DropTargetDragEvent dtde) {
            return this.component;
        }
    }

    public static interface DragRenderer {
        public Component getDragComponent(DropTargetDragEvent var1);
    }

    private static final class DefaultLoadRenderer
    implements LoadRenderer {
        public static final DefaultLoadRenderer INSTANCE = new DefaultLoadRenderer();
        private final XLabel component = new XLabel();

        private DefaultLoadRenderer() {
        }

        @Override
        public Component getLoadComponent(File file, int progress) {
            if (progress <= 0) {
                this.component.setText("Loading " + file.getName());
            } else {
                this.component.setText("<html><center><b>" + file.getName() + "</b><br>" + progress + "%");
            }
            return this.component;
        }
    }

    private static final class DefaultFailureRenderer
    implements FailureRenderer {
        public static final DefaultFailureRenderer INSTANCE = new DefaultFailureRenderer();
        private final XLabel component = new XLabel();

        private DefaultFailureRenderer() {
            this.component.setVerticalTextPosition(3);
            this.component.setHorizontalTextPosition(0);
            this.component.setIconTextGap(10);
        }

        @Override
        public Component getFailureComponent(File file, Throwable cause) {
            this.component.setText("<html><center><font size=+5>&#x26A0;</font><br>" + cause.getClass().getPackage().getName() + ".<b>" + cause.getClass().getSimpleName() + "</b><br><font size=+1>" + cause.getMessage() + "</font><br><br>");
            return this.component;
        }
    }

    public static interface FailureRenderer {
        public Component getFailureComponent(File var1, Throwable var2);
    }

    private final class FileTransferHandler
    extends TransferHandler {
        private FileTransferHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            boolean result;
            boolean bl = result = support.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || support.isDataFlavorSupported(FILE_DATA_FLAVOR);
            if (result && support.isDrop()) {
                support.setDropAction(0x40000000);
            }
            return result;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            File file = BasicFileViewer.getSingleFile(support.getTransferable());
            if (file != null) {
                BasicFileViewer.this.setFile(file);
                return true;
            }
            return false;
        }
    }

    private static final class XLabel
    extends JLabel {
        public XLabel() {
            this.setOpaque(true);
            JList resource = new JList();
            this.setBackground(resource.getSelectionForeground());
            this.setForeground(resource.getSelectionBackground());
            this.setFont(resource.getFont().deriveFont(resource.getFont().getSize2D() * 2.0f));
            this.setHorizontalAlignment(0);
        }
    }

    public static interface ProgressCallback {
        public void setProgress(int var1, int var2, int var3);
    }
}

