/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class BasicSwingLauncher {
    private static final Logger LOGGER = Logger.getLogger(BasicSwingLauncher.class.getName());
    private String lookAndFeelClassName = null;
    private String title = null;
    private Dimension size = null;
    private Callable<? extends Component> contentSupplier = null;
    private boolean centerOnScreen = true;
    private Callable<? extends List<? extends Image>> iconsSupplier = null;
    private boolean resizable = true;

    @NonNull
    public BasicSwingLauncher logLevel(@Nullable Level level) {
        LOGGER.setLevel(level);
        return this;
    }

    @NonNull
    public BasicSwingLauncher systemLookAndFeel() {
        return this.lookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }

    @NonNull
    public BasicSwingLauncher lookAndFeel(@Nullable String lookAndFeelClassName) {
        this.lookAndFeelClassName = lookAndFeelClassName;
        return this;
    }

    @NonNull
    public BasicSwingLauncher title(@Nullable String title) {
        this.title = title;
        return this;
    }

    @NonNull
    public BasicSwingLauncher size(int width, int height) {
        return this.size(new Dimension(width, height));
    }

    @NonNull
    public BasicSwingLauncher size(@Nullable Dimension size) {
        this.size = size;
        return this;
    }

    @NonNull
    public BasicSwingLauncher content(@Nullable Class<? extends Component> contentClass) {
        return this.content(contentClass == null ? null : () -> (Component)contentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
    }

    @NonNull
    public BasicSwingLauncher content(@Nullable Callable<? extends Component> contentSupplier) {
        this.contentSupplier = contentSupplier;
        return this;
    }

    @NonNull
    public BasicSwingLauncher centerOnScreen(boolean centerOnScreen) {
        this.centerOnScreen = centerOnScreen;
        return this;
    }

    @NonNull
    public BasicSwingLauncher resizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    @NonNull
    public BasicSwingLauncher icons(String ... iconsPaths) {
        if (iconsPaths == null) {
            throw new NullPointerException("iconsPaths is marked non-null but is null");
        }
        return this.icons(BasicSwingLauncher.newImageList(iconsPaths));
    }

    @NonNull
    public BasicSwingLauncher icons(@Nullable Callable<? extends List<? extends Image>> iconsSupplier) {
        this.iconsSupplier = iconsSupplier;
        return this;
    }

    public void launch() {
        BasicSwingLauncher.launch(this.lookAndFeelClassName != null ? this.lookAndFeelClassName : UIManager.getSystemLookAndFeelClassName(), this.title != null ? this.title : "SimpleApp", this.size != null ? this.size : new Dimension(800, 600), this.contentSupplier != null ? this.contentSupplier : JPanel::new, this.iconsSupplier != null ? this.iconsSupplier : BasicSwingLauncher.newImageList(new String[0]), this.centerOnScreen, this.resizable);
    }

    private static void launch(@NonNull String lookAndFeelClassName, @NonNull String title, @NonNull Dimension size, @NonNull Callable<? extends Component> contentSupplier, @NonNull Callable<? extends List<? extends Image>> iconsSupplier, boolean centerOnScreen, boolean resizable) {
        if (lookAndFeelClassName == null) {
            throw new NullPointerException("lookAndFeelClassName is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (size == null) {
            throw new NullPointerException("size is marked non-null but is null");
        }
        if (contentSupplier == null) {
            throw new NullPointerException("contentSupplier is marked non-null but is null");
        }
        if (iconsSupplier == null) {
            throw new NullPointerException("iconsSupplier is marked non-null but is null");
        }
        LOGGER.log(Level.FINE, "lookAndFeelClassName='%s'", lookAndFeelClassName);
        LOGGER.log(Level.FINE, "title='{0}'", title);
        LOGGER.log(Level.FINE, "size='{0}'", size);
        LOGGER.log(Level.FINE, "contentSupplier='{0}'", contentSupplier);
        LOGGER.log(Level.FINE, "centerOnScreen='{0}'", centerOnScreen);
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            LOGGER.log(Level.WARNING, "Cannot set look&feel", ex);
        }
        SwingUtilities.invokeLater(() -> {
            try {
                JFrame frame = new JFrame();
                frame.setTitle(title);
                frame.setIconImages((List)iconsSupplier.call());
                frame.getContentPane().add((Component)contentSupplier.call());
                frame.setDefaultCloseOperation(3);
                frame.setSize(size);
                frame.setResizable(resizable);
                if (centerOnScreen) {
                    frame.setLocationRelativeTo(null);
                }
                frame.setVisible(true);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Cannot launch app", ex);
            }
        });
    }

    @NonNull
    private static Callable<List<? extends Image>> newImageList(String ... iconsPaths) {
        if (iconsPaths == null) {
            throw new NullPointerException("iconsPaths is marked non-null but is null");
        }
        return () -> Arrays.stream(iconsPaths).map(BasicSwingLauncher.class::getResource).filter(Objects::nonNull).map(o -> new ImageIcon((URL)o).getImage()).collect(Collectors.toList());
    }
}

