/*
 * Decompiled with CFR 0.152.
 */
package ec.util.various.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class JCommand<C> {
    private static final Logger LOGGER = Logger.getLogger(JCommand.class.getName());

    @NonNull
    public static <X> JCommand<X> of(final @NonNull Consumer<X> consumer) {
        if (consumer == null) {
            throw new NullPointerException("consumer is marked non-null but is null");
        }
        return new JCommand<X>(){

            @Override
            public void execute(@NonNull X component) throws Exception {
                if (component == null) {
                    throw new NullPointerException("component is marked non-null but is null");
                }
                consumer.accept(component);
            }
        };
    }

    public abstract void execute(@NonNull C var1) throws Exception;

    public @Nullable Exception executeSafely(@NonNull C component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        try {
            this.execute(component);
            return null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "While executing command", ex);
            return ex;
        }
    }

    public boolean isEnabled(@NonNull C component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return true;
    }

    public boolean isSelected(@NonNull C component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return false;
    }

    @NonNull
    public ActionAdapter toAction(@NonNull C component) {
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        return new ActionAdapter(component);
    }

    public class ActionAdapter
    extends AbstractAction {
        @NonNull
        private final C component;
        private boolean listening;

        public ActionAdapter(C component) {
            if (component == null) {
                throw new NullPointerException("component is marked non-null but is null");
            }
            this.component = component;
            this.listening = true;
            this.refreshActionState();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Exception ex;
            this.listening = false;
            if (this.isEnabled() && (ex = JCommand.this.executeSafely(this.component)) != null) {
                this.handleException(e, ex);
            }
            this.listening = true;
            this.refreshActionState();
        }

        public void handleException(ActionEvent event, Exception ex) {
        }

        public final void refreshActionState() {
            if (this.listening) {
                this.setEnabled(JCommand.this.isEnabled(this.component));
                this.putValue("SwingSelectedKey", JCommand.this.isSelected(this.component));
            }
        }

        @NonNull
        public ActionAdapter withWeakPropertyChangeListener(@NonNull Component source, String ... properties) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            if (properties == null) {
                throw new NullPointerException("properties is marked non-null but is null");
            }
            PropertyChangeListener realListener = evt -> this.refreshActionState();
            this.putValue("PropertyChangeListener", realListener);
            if (properties.length > 0) {
                for (final String property : properties) {
                    source.addPropertyChangeListener(property, new WeakPropertyChangeListener(realListener){

                        @Override
                        protected void unregister(@NonNull Object source) {
                            if (source == null) {
                                throw new NullPointerException("source is marked non-null but is null");
                            }
                            ((Component)source).removePropertyChangeListener(property, this);
                        }
                    });
                }
            } else {
                source.addPropertyChangeListener(new WeakPropertyChangeListener(realListener){

                    @Override
                    protected void unregister(@NonNull Object source) {
                        if (source == null) {
                            throw new NullPointerException("source is marked non-null but is null");
                        }
                        ((Component)source).removePropertyChangeListener(this);
                    }
                });
            }
            return this;
        }

        @NonNull
        public ActionAdapter withWeakListSelectionListener(@NonNull ListSelectionModel source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            ListSelectionListener realListener = evt -> this.refreshActionState();
            this.putValue("ListSelectionListener", realListener);
            source.addListSelectionListener(new WeakListSelectionListener(realListener){

                @Override
                protected void unregister(@NonNull Object source) {
                    if (source == null) {
                        throw new NullPointerException("source is marked non-null but is null");
                    }
                    ((ListSelectionModel)source).removeListSelectionListener(this);
                }
            });
            return this;
        }

        @NonNull
        public ActionAdapter withWeakTableModelListener(@NonNull TableModel source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            TableModelListener realListener = evt -> this.refreshActionState();
            this.putValue("TableModelListener", realListener);
            source.addTableModelListener(new WeakTableModelListener(realListener){

                @Override
                protected void unregister(@NonNull Object source) {
                    if (source == null) {
                        throw new NullPointerException("source is marked non-null but is null");
                    }
                    ((TableModel)source).removeTableModelListener(this);
                }
            });
            return this;
        }

        @Deprecated
        public void registerPropertyChangeListener(@NonNull Container source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.withWeakPropertyChangeListener(source, new String[0]);
        }

        @Deprecated
        public void registerListSelectionListener(@NonNull ListSelectionModel source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.withWeakListSelectionListener(source);
        }
    }

    private static abstract class WeakTableModelListener
    extends WeakEventListener<TableModelListener>
    implements TableModelListener {
        public WeakTableModelListener(@NonNull TableModelListener delegate) {
            super(delegate);
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            TableModelListener listener = (TableModelListener)this.delegate.get();
            if (listener != null) {
                listener.tableChanged(e);
            } else {
                this.unregister(e.getSource());
            }
        }
    }

    private static abstract class WeakListSelectionListener
    extends WeakEventListener<ListSelectionListener>
    implements ListSelectionListener {
        public WeakListSelectionListener(@NonNull ListSelectionListener delegate) {
            super(delegate);
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionListener listener = (ListSelectionListener)this.delegate.get();
            if (listener != null) {
                listener.valueChanged(e);
            } else {
                this.unregister(e.getSource());
            }
        }
    }

    private static abstract class WeakPropertyChangeListener
    extends WeakEventListener<PropertyChangeListener>
    implements PropertyChangeListener {
        public WeakPropertyChangeListener(@NonNull PropertyChangeListener delegate) {
            super(delegate);
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeListener listener = (PropertyChangeListener)this.delegate.get();
            if (listener != null) {
                listener.propertyChange(evt);
            } else {
                this.unregister(evt.getSource());
            }
        }
    }

    public static abstract class WeakEventListener<T extends EventListener>
    implements EventListener {
        protected final WeakReference<T> delegate;

        public WeakEventListener(@NonNull T delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = new WeakReference<T>(delegate);
        }

        protected abstract void unregister(@NonNull Object var1);
    }
}

