/*
 * Decompiled with CFR 0.152.
 */
package internal.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import lombok.NonNull;
import nbbrd.io.FileFormatter;
import nbbrd.io.function.IOSupplier;

public class ComposeFileFormatter<V, T>
implements FileFormatter<V> {
    @NonNull
    protected final FileFormatter<T> formatter;
    @NonNull
    protected final Function<? super V, ? extends T> before;

    @Override
    public void formatFile(V value, File target) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatFile(this.before.apply(value), target);
    }

    @Override
    public void formatPath(V value, Path target) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatPath(this.before.apply(value), target);
    }

    @Override
    public void formatStream(V value, IOSupplier<? extends OutputStream> target) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatStream(this.before.apply(value), target);
    }

    @Override
    public void formatStream(V value, OutputStream resource) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatStream(this.before.apply(value), resource);
    }

    public ComposeFileFormatter(@NonNull FileFormatter<T> formatter, @NonNull Function<? super V, ? extends T> before) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        if (before == null) {
            throw new NullPointerException("before is marked non-null but is null");
        }
        this.formatter = formatter;
        this.before = before;
    }
}

