/*
 * Decompiled with CFR 0.152.
 */
package internal.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import nbbrd.io.IOIterator;
import nbbrd.io.function.IOConsumer;
import nbbrd.io.function.IOPredicate;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.function.IOUnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IOIterators {
    private IOIterators() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class Functional<E>
    implements IOIterator<E> {
        @NonNull
        private final IOSupplier<E> seed;
        @NonNull
        private final IOPredicate<? super E> hasNext;
        @NonNull
        private final IOUnaryOperator<E> next;
        private boolean seeded = false;
        private E nextValue = null;

        @Override
        public boolean hasNextWithIO() throws IOException {
            if (!this.seeded) {
                this.seeded = true;
                this.nextValue = this.seed.getWithIO();
            }
            return this.hasNext.testWithIO(this.nextValue);
        }

        @Override
        public E nextWithIO() throws IOException, NoSuchElementException {
            if (!this.hasNextWithIO()) {
                throw new NoSuchElementException();
            }
            E result = this.nextValue;
            this.nextValue = this.next.applyWithIO(this.nextValue);
            return result;
        }

        public Functional(@NonNull IOSupplier<E> seed, @NonNull IOPredicate<? super E> hasNext, @NonNull IOUnaryOperator<E> next) {
            if (seed == null) {
                throw new NullPointerException("seed is marked non-null but is null");
            }
            if (hasNext == null) {
                throw new NullPointerException("hasNext is marked non-null but is null");
            }
            if (next == null) {
                throw new NullPointerException("next is marked non-null but is null");
            }
            this.seed = seed;
            this.hasNext = hasNext;
            this.next = next;
        }
    }

    public static final class Unchecked<E>
    implements Iterator<E> {
        @NonNull
        private final IOIterator<E> delegate;

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNextWithIO();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        @Override
        public E next() {
            try {
                return this.delegate.nextWithIO();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        @Override
        public void remove() {
            try {
                this.delegate.removeWithIO();
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            try {
                this.delegate.forEachRemainingWithIO(IOConsumer.checked(action));
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }

        public Unchecked(@NonNull IOIterator<E> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }

        @NonNull
        public IOIterator<E> getDelegate() {
            return this.delegate;
        }
    }

    public static final class Checked<E>
    implements IOIterator<E> {
        @NonNull
        private final Iterator<E> delegate;

        @Override
        public boolean hasNextWithIO() throws IOException {
            try {
                return this.delegate.hasNext();
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }

        @Override
        public E nextWithIO() throws IOException, NoSuchElementException {
            try {
                return this.delegate.next();
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }

        @Override
        public void removeWithIO() throws IOException {
            try {
                this.delegate.remove();
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }

        @Override
        public void forEachRemainingWithIO(IOConsumer<? super E> action) throws IOException {
            try {
                this.delegate.forEachRemaining(action.asUnchecked());
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        }

        @Override
        public Stream<E> asStream() {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.delegate, 0), false);
        }

        @Override
        public Iterator<E> asUnchecked() {
            return this.delegate;
        }

        public Checked(@NonNull Iterator<E> delegate) {
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.delegate = delegate;
        }

        @NonNull
        public Iterator<E> getDelegate() {
            return this.delegate;
        }
    }

    public static final class Singleton<E>
    implements IOIterator<E> {
        private final @Nullable E element;
        private boolean first = true;

        @Override
        public boolean hasNextWithIO() throws IOException {
            return this.first;
        }

        @Override
        public E nextWithIO() throws IOException, NoSuchElementException {
            if (!this.hasNextWithIO()) {
                throw new NoSuchElementException();
            }
            this.first = false;
            return this.element;
        }

        public Singleton(@Nullable E element) {
            this.element = element;
        }
    }

    public static enum Empty implements IOIterator<Object>
    {
        INSTANCE;


        @Override
        public boolean hasNextWithIO() throws IOException {
            return false;
        }

        @Override
        public Object nextWithIO() throws IOException, NoSuchElementException {
            throw new NoSuchElementException();
        }

        @Override
        public Stream<Object> asStream() {
            return Stream.empty();
        }

        @Override
        public Iterator<Object> asUnchecked() {
            return Collections.emptyIterator();
        }
    }
}

