/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import lombok.NonNull;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.text.TextFormatter;

public class ComposeTextFormatter<V, T>
implements TextFormatter<V> {
    @NonNull
    protected final TextFormatter<T> formatter;
    @NonNull
    protected final Function<? super V, ? extends T> before;

    @Override
    public String formatToString(V value) throws IOException {
        Objects.requireNonNull(value, "value");
        return this.formatter.formatToString(this.before.apply(value));
    }

    @Override
    public void formatChars(V value, Appendable target) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatChars(this.before.apply(value), target);
    }

    @Override
    public void formatFile(V value, File target, Charset encoding) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatFile(this.before.apply(value), target, encoding);
    }

    @Override
    public void formatPath(V value, Path target, Charset encoding) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatPath(this.before.apply(value), target, encoding);
    }

    @Override
    public void formatWriter(V value, IOSupplier<? extends Writer> target) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatWriter(this.before.apply(value), target);
    }

    @Override
    public void formatStream(V value, IOSupplier<? extends OutputStream> target, Charset encoding) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatStream(this.before.apply(value), target, encoding);
    }

    @Override
    public void formatWriter(V value, Writer resource) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatWriter(this.before.apply(value), resource);
    }

    @Override
    public void formatStream(V value, OutputStream resource, Charset encoding) throws IOException {
        Objects.requireNonNull(value, "value");
        this.formatter.formatStream(this.before.apply(value), resource, encoding);
    }

    public ComposeTextFormatter(@NonNull TextFormatter<T> formatter, @NonNull Function<? super V, ? extends T> before) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        if (before == null) {
            throw new NullPointerException("before is marked non-null but is null");
        }
        this.formatter = formatter;
        this.before = before;
    }
}

