/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.time.DateTimeException;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public final class InternalFormatter {
    public static CharSequence formatTemporalAccessor(DateTimeFormatter formatter, TemporalAccessor value) {
        if (value != null) {
            try {
                return formatter.format(value);
            }
            catch (DateTimeException dateTimeException) {
                // empty catch block
            }
        }
        return null;
    }

    public static CharSequence formatDate(DateFormat format, Date value) {
        return value != null ? format.format(value) : null;
    }

    public static CharSequence formatNumber(NumberFormat format, Number value) {
        return value != null ? format.format(value) : null;
    }

    public static CharSequence formatDoubleArray(double[] value) {
        return value != null ? Arrays.toString(value) : null;
    }

    public static CharSequence formatStringArray(String[] value) {
        return value != null ? Arrays.toString(value) : null;
    }

    public static CharSequence formatStringList(Function<Stream<CharSequence>, String> joiner, List<String> value) {
        if (value != null) {
            try {
                return joiner.apply(value.stream().map(CharSequence.class::cast));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static <T> CharSequence formatConstant(CharSequence constant, T value) {
        return constant;
    }

    public static <T> CharSequence formatNull(T value) {
        return null;
    }

    public static <T> CharSequence formatFile(File value) {
        return value != null ? value.getPath() : null;
    }

    public static <T> CharSequence formatInteger(Integer value) {
        return value != null ? value.toString() : null;
    }

    public static <T> CharSequence formatLong(Long value) {
        return value != null ? value.toString() : null;
    }

    public static <T> CharSequence formatDouble(Double value) {
        return value != null ? value.toString() : null;
    }

    public static <T> CharSequence formatBoolean(Boolean value) {
        return value != null ? value.toString() : null;
    }

    public static <T> CharSequence formatCharacter(Character value) {
        return value != null ? value.toString() : null;
    }

    public static <T> CharSequence formatCharset(Charset value) {
        return value != null ? value.name() : null;
    }

    public static <T> CharSequence formatEnum(Enum value) {
        return value != null ? value.name() : null;
    }

    public static <T> CharSequence formatString(String value) {
        return value;
    }

    public static <T> CharSequence formatObjectToString(Object value) {
        return value != null ? value.toString() : null;
    }

    public static CharSequence formatURL(URL value) {
        return value != null ? value.toString() : null;
    }

    private InternalFormatter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

