/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

final class NumberFormats {
    public static @Nullable Number parseAll(@NonNull NumberFormat numberFormat, @NonNull CharSequence input) {
        String source = input.toString();
        ParsePosition pos = new ParsePosition(0);
        Number result = numberFormat.parse(source, pos);
        return pos.getIndex() == input.length() ? result : null;
    }

    public static @NonNull CharSequence simplify(@NonNull NumberFormat numberFormat, @NonNull CharSequence input) {
        Objects.requireNonNull(numberFormat);
        return NumberFormats.hasGroupingSpaceChar(numberFormat) ? NumberFormats.removeGroupingSpaceChars(input) : Objects.requireNonNull(input);
    }

    private static boolean hasGroupingSpaceChar(NumberFormat format) {
        return format instanceof DecimalFormat && NumberFormats.hasGroupingSpaceChar(((DecimalFormat)format).getDecimalFormatSymbols());
    }

    private static boolean hasGroupingSpaceChar(DecimalFormatSymbols symbols) {
        return Character.isSpaceChar(symbols.getGroupingSeparator());
    }

    private static CharSequence removeGroupingSpaceChars(CharSequence input) {
        if (input.length() < 2) {
            return input;
        }
        StringBuilder result = new StringBuilder(input.length());
        result.append(input.charAt(0));
        for (int i = 1; i < input.length() - 1; ++i) {
            if (NumberFormats.isGroupingSpaceChar(input, i)) continue;
            result.append(input.charAt(i));
        }
        result.append(input.charAt(input.length() - 1));
        return result.length() != input.length() ? result.toString() : input;
    }

    private static boolean isGroupingSpaceChar(CharSequence array, int index) {
        return Character.isSpaceChar(array.charAt(index)) && Character.isDigit(array.charAt(index - 1)) && Character.isDigit(array.charAt(index + 1));
    }

    private NumberFormats() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

