/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.UnaryOperator;
import nbbrd.io.function.IOFunction;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface IOUnaryOperator<T>
extends IOFunction<T, T> {
    default public @NonNull UnaryOperator<T> asUnchecked() {
        return t -> {
            try {
                return this.applyWithIO(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static <T> @NonNull UnaryOperator<T> unchecked(@NonNull IOUnaryOperator<T> o) {
        return o.asUnchecked();
    }

    public static <T> @NonNull IOUnaryOperator<T> checked(@NonNull UnaryOperator<T> func) {
        Objects.requireNonNull(func);
        return o -> {
            try {
                return func.apply(o);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T> @NonNull IOUnaryOperator<T> identity() {
        return t -> t;
    }
}

