/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.sys;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.stream.Collectors;

public final class EndOfProcessException
extends IOException {
    private final int exitValue;
    private final String errorMessage;

    public static EndOfProcessException of(Process process) throws IOException {
        return new EndOfProcessException(process.exitValue(), EndOfProcessException.readErrorStream(process));
    }

    private EndOfProcessException(int exitValue, String errorMessage) {
        super("Invalid exit value: " + exitValue + " " + errorMessage);
        this.exitValue = exitValue;
        this.errorMessage = errorMessage;
    }

    private static String readErrorStream(Process process) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getErrorStream(), Charset.defaultCharset()));){
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

