/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.sys;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.stream.Collectors;
import nbbrd.io.sys.EndOfProcessException;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class ProcessReader {
    public static @NonNull BufferedReader newReader(String ... args) throws IOException {
        return ProcessReader.newReader(new ProcessBuilder(args).start());
    }

    public static @NonNull BufferedReader newReader(@NonNull Process process) throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new ProcessInputStream(process), Charset.defaultCharset()));
    }

    public static @NonNull String readToString(String ... args) throws IOException {
        return ProcessReader.readToString(new ProcessBuilder(args).start());
    }

    public static @NonNull String readToString(@NonNull Process process) throws IOException {
        try (BufferedReader reader = ProcessReader.newReader(process);){
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    private ProcessReader() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class ProcessInputStream
    extends InputStream {
        private final InputStream delegate;
        private final Process process;

        public ProcessInputStream(Process process) {
            this.delegate = process.getInputStream();
            this.process = process;
        }

        @Override
        public void close() throws IOException {
            try {
                this.readUntilEnd();
                this.waitForEndOfProcess();
            }
            finally {
                this.delegate.close();
            }
        }

        private void readUntilEnd() throws IOException {
            while (this.delegate.read() != -1) {
            }
        }

        private void waitForEndOfProcess() throws IOException {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
            if (this.process.exitValue() != 0) {
                throw EndOfProcessException.of(this.process);
            }
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public byte[] readAllBytes() throws IOException {
            return this.delegate.readAllBytes();
        }

        @Override
        public byte[] readNBytes(int len) throws IOException {
            return this.delegate.readNBytes(len);
        }

        @Override
        public int readNBytes(byte[] b, int off, int len) throws IOException {
            return this.delegate.readNBytes(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }

        @Override
        public long transferTo(OutputStream out) throws IOException {
            return this.delegate.transferTo(out);
        }
    }
}

