/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.sys;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class SystemProperties {
    public static final String FILE_SEPARATOR = "file.separator";
    public static final String JAVA_CLASS_PATH = "java.class.path";
    public static final String JAVA_CLASS_VERSION = "java.class.version";
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_LIBRARY_PATH = "java.library.path";
    public static final String JAVA_VENDOR = "java.vendor";
    public static final String JAVA_VENDOR_URL = "java.vendor.url";
    public static final String JAVA_VERSION = "java.version";
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir";
    public static final String JAVA_COMPILER = "java.compiler";
    public static final String LINE_SEPARATOR = "line.separator";
    public static final String OS_ARCH = "os.arch";
    public static final String OS_NAME = "os.name";
    public static final String OS_VERSION = "os.version";
    public static final String PATH_SEPARATOR = "path.separator";
    public static final String USER_DIR = "user.dir";
    public static final String USER_HOME = "user.home";
    public static final String USER_NAME = "user.name";
    public static final String JAVA_VM_SPECIFICATION_VERSION = "java.vm.specification.version";
    public static final String JAVA_VM_SPECIFICATION_VENDOR = "java.vm.specification.vendor";
    public static final String JAVA_VM_SPECIFICATION_NAME = "java.vm.specification.name";
    public static final String JAVA_VM_VERSION = "java.vm.version";
    public static final String JAVA_VM_VENDOR = "java.vm.vendor";
    public static final String JAVA_VM_NAME = "java.vm.name";
    public static final String JAVA_SPECIFICATION_VERSION = "java.specification.version";
    public static final String JAVA_SPECIFICATION_VENDOR = "java.specification.vendor";
    public static final String JAVA_SPECIFICATION_NAME = "java.specification.name";
    public static final SystemProperties DEFAULT = SystemProperties.of(System.getProperties(), FileSystems.getDefault());
    @lombok.NonNull
    private final Properties source;
    @lombok.NonNull
    private final FileSystem fileSystem;

    public @Nullable Character getFileSeparator() {
        return this.asChar(this.get(FILE_SEPARATOR));
    }

    public @NonNull List<Path> getJavaClassPath() {
        return this.asPaths(this.get(JAVA_CLASS_PATH));
    }

    public @Nullable String getJavaClassVersion() {
        return this.get(JAVA_CLASS_VERSION);
    }

    public @Nullable Path getJavaHome() {
        return this.asPath(this.get(JAVA_HOME));
    }

    public @NonNull List<Path> getJavaLibraryPath() {
        return this.asPaths(this.get(JAVA_LIBRARY_PATH));
    }

    public @Nullable String getJavaVendor() {
        return this.get(JAVA_VENDOR);
    }

    public @Nullable URL getJavaVendorUrl() {
        return this.asURL(this.get(JAVA_VENDOR_URL));
    }

    public @Nullable String getJavaVersion() {
        return this.get(JAVA_VERSION);
    }

    public @Nullable Path getJavaIoTmpdir() {
        return this.asPath(this.get(JAVA_IO_TMPDIR));
    }

    public @Nullable String getJavaCompiler() {
        return this.get(JAVA_COMPILER);
    }

    public @Nullable String getLineSeparator() {
        return this.get(LINE_SEPARATOR);
    }

    public @Nullable String getOsArch() {
        return this.get(OS_ARCH);
    }

    public @Nullable String getOsName() {
        return this.get(OS_NAME);
    }

    public @Nullable String getOsVersion() {
        return this.get(OS_VERSION);
    }

    public @Nullable Character getPathSeparator() {
        return this.asChar(this.get(PATH_SEPARATOR));
    }

    public @Nullable Path getUserDir() {
        return this.asPath(this.get(USER_DIR));
    }

    public @Nullable Path getUserHome() {
        return this.asPath(this.get(USER_HOME));
    }

    public @Nullable String getUserName() {
        return this.get(USER_NAME);
    }

    public @Nullable String getJavaVmSpecificationVersion() {
        return this.get(JAVA_VM_SPECIFICATION_VERSION);
    }

    public @Nullable String getJavaVmSpecificationVendor() {
        return this.get(JAVA_VM_SPECIFICATION_VENDOR);
    }

    public @Nullable String getJavaVmSpecificationName() {
        return this.get(JAVA_VM_SPECIFICATION_NAME);
    }

    public @Nullable String getJavaVmVersion() {
        return this.get(JAVA_VM_VERSION);
    }

    public @Nullable String getJavaVmVendor() {
        return this.get(JAVA_VM_VENDOR);
    }

    public @Nullable String getJavaVmName() {
        return this.get(JAVA_VM_NAME);
    }

    public @Nullable String getJavaSpecificationVersion() {
        return this.get(JAVA_SPECIFICATION_VERSION);
    }

    public @Nullable String getJavaSpecificationVendor() {
        return this.get(JAVA_SPECIFICATION_VENDOR);
    }

    public @Nullable String getJavaSpecificationName() {
        return this.get(JAVA_SPECIFICATION_NAME);
    }

    private String get(String key) {
        return this.source.getProperty(key);
    }

    private Path asPath(String input) {
        return input != null ? this.fileSystem.getPath(input, new String[0]) : null;
    }

    private Character asChar(String input) {
        return input != null && input.length() == 1 ? Character.valueOf(input.charAt(0)) : null;
    }

    private List<Path> asPaths(String input) {
        Character pathSeparator;
        if (input != null && !input.isEmpty() && (pathSeparator = this.getPathSeparator()) != null) {
            return Stream.of(input.split(pathSeparator.toString(), -1)).map(this::asPath).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private URL asURL(String input) {
        try {
            return input != null ? new URL(input) : null;
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private SystemProperties(@lombok.NonNull Properties source, @lombok.NonNull FileSystem fileSystem) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (fileSystem == null) {
            throw new NullPointerException("fileSystem is marked non-null but is null");
        }
        this.source = source;
        this.fileSystem = fileSystem;
    }

    public static SystemProperties of(@lombok.NonNull Properties source, @lombok.NonNull FileSystem fileSystem) {
        return new SystemProperties(source, fileSystem);
    }
}

