/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import internal.io.text.InternalFormatter;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface Formatter<T> {
    public @Nullable CharSequence format(@Nullable T var1);

    default public @Nullable String formatAsString(@Nullable T value) {
        CharSequence result = this.format(value);
        return result != null ? result.toString() : null;
    }

    default public @NonNull Optional<CharSequence> formatValue(@Nullable T value) {
        return Optional.ofNullable(this.format(value));
    }

    default public @NonNull Optional<String> formatValueAsString(@Nullable T value) {
        return Optional.ofNullable(this.formatAsString(value));
    }

    default public <Y> @NonNull Formatter<Y> compose(@NonNull Function<? super Y, ? extends T> before) {
        Objects.requireNonNull(before);
        return o -> this.format(before.apply((Object)o));
    }

    public static <T extends TemporalAccessor> @NonNull Formatter<T> onDateTimeFormatter(@NonNull DateTimeFormatter formatter) {
        Objects.requireNonNull(formatter);
        return o -> InternalFormatter.formatTemporalAccessor(formatter, o);
    }

    public static @NonNull Formatter<Date> onDateFormat(@NonNull DateFormat dateFormat) {
        Objects.requireNonNull(dateFormat);
        return o -> InternalFormatter.formatDate(dateFormat, o);
    }

    public static @NonNull Formatter<Number> onNumberFormat(@NonNull NumberFormat numberFormat) {
        Objects.requireNonNull(numberFormat);
        return o -> InternalFormatter.formatNumber(numberFormat, o);
    }

    public static <T> @NonNull Formatter<T> onConstant(@Nullable CharSequence instance) {
        return o -> InternalFormatter.formatConstant(instance, o);
    }

    public static <T> @NonNull Formatter<T> onNull() {
        return InternalFormatter::formatNull;
    }

    public static @NonNull Formatter<File> onFile() {
        return InternalFormatter::formatFile;
    }

    public static @NonNull Formatter<Integer> onInteger() {
        return InternalFormatter::formatInteger;
    }

    public static @NonNull Formatter<Long> onLong() {
        return InternalFormatter::formatLong;
    }

    public static @NonNull Formatter<Double> onDouble() {
        return InternalFormatter::formatDouble;
    }

    public static @NonNull Formatter<Boolean> onBoolean() {
        return InternalFormatter::formatBoolean;
    }

    public static @NonNull Formatter<Character> onCharacter() {
        return InternalFormatter::formatCharacter;
    }

    public static @NonNull Formatter<Charset> onCharset() {
        return InternalFormatter::formatCharset;
    }

    public static <T extends Enum<T>> @NonNull Formatter<T> onEnum() {
        return InternalFormatter::formatEnum;
    }

    public static @NonNull Formatter<String> onString() {
        return InternalFormatter::formatString;
    }

    public static @NonNull Formatter<Object> onObjectToString() {
        return InternalFormatter::formatObjectToString;
    }

    public static @NonNull Formatter<double[]> onDoubleArray() {
        return InternalFormatter::formatDoubleArray;
    }

    public static @NonNull Formatter<String[]> onStringArray() {
        return InternalFormatter::formatStringArray;
    }

    public static @NonNull Formatter<List<String>> onStringList(@NonNull Function<Stream<CharSequence>, String> joiner) {
        Objects.requireNonNull(joiner);
        return o -> InternalFormatter.formatStringList(joiner, o);
    }

    public static @NonNull Formatter<URL> onURL() {
        return InternalFormatter::formatURL;
    }
}

