/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io;

import internal.io.ComposeFileFormatter;
import internal.io.text.LegacyFiles;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import nbbrd.io.Resource;
import nbbrd.io.function.IOSupplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface FileFormatter<T> {
    default public void formatFile(@NonNull T value, @NonNull File target) throws IOException {
        Objects.requireNonNull(value, "value");
        LegacyFiles.checkTarget(target);
        this.formatStream(value, () -> LegacyFiles.newOutputStream(target));
    }

    default public void formatPath(@NonNull T value, @NonNull Path target) throws IOException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(target, "target");
        Optional<File> file = Resource.getFile(target);
        if (file.isPresent()) {
            this.formatFile(value, file.get());
        } else {
            this.formatStream(value, () -> Files.newOutputStream(target, new OpenOption[0]));
        }
    }

    default public void formatStream(@NonNull T value, IOSupplier<? extends OutputStream> target) throws IOException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(target, "target");
        try (OutputStream resource = LegacyFiles.checkResource(target.getWithIO(), "Missing OutputStream");){
            this.formatStream(value, resource);
        }
    }

    public void formatStream(@NonNull T var1, @NonNull OutputStream var2) throws IOException;

    default public <V> @NonNull FileFormatter<V> compose(@NonNull Function<? super V, ? extends T> before) {
        return new ComposeFileFormatter<V, T>(this, before);
    }
}

