/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.function;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.checkerframework.checker.nullness.qual.NonNull;

@FunctionalInterface
public interface IOBiConsumer<T, U> {
    public void acceptWithIO(T var1, U var2) throws IOException;

    default public IOBiConsumer<T, U> andThen(IOBiConsumer<? super T, ? super U> after) {
        Objects.requireNonNull(after);
        return (l, r) -> {
            this.acceptWithIO(l, r);
            after.acceptWithIO(l, r);
        };
    }

    default public @NonNull BiConsumer<T, U> asUnchecked() {
        return (t, u) -> {
            try {
                this.acceptWithIO(t, u);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public static <T, U> @NonNull BiConsumer<T, U> unchecked(@NonNull IOBiConsumer<T, U> o) {
        return o.asUnchecked();
    }

    public static <T, U> @NonNull IOBiConsumer<T, U> checked(@NonNull BiConsumer<T, U> consumer) {
        return (t, u) -> {
            try {
                consumer.accept(t, u);
            }
            catch (UncheckedIOException ex) {
                throw ex.getCause();
            }
        };
    }

    public static <T, U> @NonNull IOBiConsumer<T, U> noOp() {
        return (t, u) -> {};
    }
}

