/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import internal.io.text.InternalParser;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalQuery;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@FunctionalInterface
public interface Parser<T> {
    public @Nullable T parse(@Nullable CharSequence var1);

    default public @NonNull Optional<T> parseValue(@Nullable CharSequence input) {
        return Optional.ofNullable(this.parse(input));
    }

    default public @NonNull Parser<T> orElse(@NonNull Parser<T> other) {
        Objects.requireNonNull(other);
        return o -> {
            T result = this.parse(o);
            return result != null ? result : other.parse(o);
        };
    }

    default public <X> @NonNull Parser<X> andThen(@NonNull Function<? super T, ? extends X> after) {
        Objects.requireNonNull(after);
        return o -> after.apply((T)this.parse(o));
    }

    public static <T> @NonNull Parser<T> onDateTimeFormatter(@NonNull DateTimeFormatter formatter, TemporalQuery<T> ... queries) {
        Objects.requireNonNull(formatter);
        Objects.requireNonNull(queries);
        return o -> InternalParser.parseTemporalAccessor(formatter, queries, o);
    }

    public static @NonNull Parser<Date> onDateFormat(@NonNull DateFormat dateFormat) {
        Objects.requireNonNull(dateFormat);
        return o -> InternalParser.parseDate(dateFormat, o);
    }

    public static @NonNull Parser<Number> onNumberFormat(@NonNull NumberFormat numberFormat) {
        Objects.requireNonNull(numberFormat);
        return o -> InternalParser.parseNumber(numberFormat, o);
    }

    public static <T> @NonNull Parser<T> onConstant(@Nullable T instance) {
        return o -> InternalParser.parseConstant(instance, o);
    }

    public static <T> @NonNull Parser<T> onNull() {
        return InternalParser::parseNull;
    }

    public static @NonNull Parser<File> onFile() {
        return InternalParser::parseFile;
    }

    public static @NonNull Parser<Integer> onInteger() {
        return InternalParser::parseInteger;
    }

    public static @NonNull Parser<Long> onLong() {
        return InternalParser::parseLong;
    }

    public static @NonNull Parser<Double> onDouble() {
        return InternalParser::parseDouble;
    }

    public static @NonNull Parser<Boolean> onBoolean() {
        return InternalParser::parseBoolean;
    }

    public static @NonNull Parser<Character> onCharacter() {
        return InternalParser::parseCharacter;
    }

    public static @NonNull Parser<Charset> onCharset() {
        return InternalParser::parseCharset;
    }

    public static <T extends Enum<T>> @NonNull Parser<T> onEnum(@NonNull Class<T> type) {
        Objects.requireNonNull(type);
        return o -> InternalParser.parseEnum(type, o);
    }

    public static <T extends Enum<T>> @NonNull Parser<T> onEnum(@NonNull Class<T> type, @NonNull ToIntFunction<T> function) {
        Enum[] values = (Enum[])type.getEnumConstants();
        Objects.requireNonNull(function);
        return Parser.onInteger().andThen(code -> InternalParser.parse(values, function, code));
    }

    public static @NonNull Parser<String> onString() {
        return InternalParser::parseString;
    }

    public static @NonNull Parser<double[]> onDoubleArray() {
        return InternalParser::parseDoubleArray;
    }

    public static @NonNull Parser<String[]> onStringArray() {
        return InternalParser::parseStringArray;
    }

    public static @NonNull Parser<List<String>> onStringList(@NonNull Function<CharSequence, @NonNull Stream<String>> splitter) {
        Objects.requireNonNull(splitter);
        return o -> InternalParser.parseStringList(splitter, o);
    }

    public static @NonNull Parser<Locale> onLocale() {
        return InternalParser::parseLocale;
    }

    public static @NonNull Parser<URL> onURL() {
        return InternalParser::parseURL;
    }

    public static @NonNull Parser<URI> onURI() {
        return InternalParser::parseURI;
    }

    public static <T> @NonNull Parser<T> of(@NonNull Function<? super CharSequence, ? extends T> parser, @NonNull Consumer<? super Throwable> onError) {
        Objects.requireNonNull(parser);
        Objects.requireNonNull(onError);
        return o -> InternalParser.parseFailsafe(parser, onError, o);
    }

    public static <T> @NonNull Parser<T> of(@NonNull Function<? super CharSequence, ? extends T> parser) {
        return Parser.of(parser, InternalParser::doNothing);
    }
}

