/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import internal.io.text.AndThenTextParser;
import internal.io.text.FunctionalTextParser;
import internal.io.text.LegacyFiles;
import internal.io.text.WithCharsetFileParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import nbbrd.io.FileParser;
import nbbrd.io.Resource;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IOSupplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface TextParser<T> {
    default public @NonNull T parseChars(@NonNull CharSequence source) throws IOException {
        Objects.requireNonNull(source, "source");
        return this.parseReader(() -> new StringReader(source.toString()));
    }

    default public @NonNull T parseFile(@NonNull File source, @NonNull Charset encoding) throws IOException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(encoding, "encoding");
        LegacyFiles.checkSource(source);
        return this.parseStream(() -> LegacyFiles.newInputStream(source), encoding);
    }

    default public @NonNull T parsePath(@NonNull Path source, @NonNull Charset encoding) throws IOException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(encoding, "encoding");
        Optional<File> file = Resource.getFile(source);
        return file.isPresent() ? this.parseFile(file.get(), encoding) : this.parseStream(() -> Files.newInputStream(source, new OpenOption[0]), encoding);
    }

    default public @NonNull T parseResource(@NonNull Class<?> type, @NonNull String name, @NonNull Charset encoding) throws IOException {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(encoding, "encoding");
        return this.parseStream(() -> LegacyFiles.checkResource(type.getResourceAsStream(name), "Missing resource '" + name + "' of '" + type.getName() + "'"), encoding);
    }

    default public @NonNull T parseReader(@NonNull IOSupplier<? extends Reader> source) throws IOException {
        Objects.requireNonNull(source, "source");
        try (Reader resource = LegacyFiles.checkResource(source.getWithIO(), "Missing Reader");){
            T t = this.parseReader(resource);
            return t;
        }
    }

    default public @NonNull T parseStream(@NonNull IOSupplier<? extends InputStream> source, @NonNull Charset encoding) throws IOException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(encoding, "encoding");
        try (InputStream resource = LegacyFiles.checkResource(source.getWithIO(), "Missing InputStream");){
            T t = this.parseStream(resource, encoding);
            return t;
        }
    }

    public @NonNull T parseReader(@NonNull Reader var1) throws IOException;

    public @NonNull T parseStream(@NonNull InputStream var1, @NonNull Charset var2) throws IOException;

    default public <V> @NonNull TextParser<V> andThen(@NonNull Function<? super T, ? extends V> after) {
        return new AndThenTextParser<T, V>(this, after);
    }

    default public @NonNull FileParser<T> withCharset(@NonNull Charset encoding) {
        return new WithCharsetFileParser(this, encoding);
    }

    public static <T> @NonNull TextParser<T> onParsingReader(@NonNull IOFunction<? super Reader, ? extends T> function) {
        return new FunctionalTextParser<T>(function);
    }
}

