/*
 * Decompiled with CFR 0.152.
 */
package _test.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import nbbrd.io.Resource;
import nbbrd.io.text.TextResource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ResourceId {
    @lombok.NonNull
    private final Class<?> anchor;
    @lombok.NonNull
    private final String name;

    public InputStream open() throws IOException {
        return (InputStream)Resource.getResourceAsStream(this.anchor, (String)this.name).orElseThrow(IOException::new);
    }

    public Path copyTo(Path temp) throws IOException {
        Path result = Files.createTempFile(temp, "x", "y", new FileAttribute[0]);
        try (InputStream stream = this.open();){
            Files.copy(stream, result, StandardCopyOption.REPLACE_EXISTING);
        }
        return result;
    }

    public BufferedReader open(Charset encoding) throws IOException {
        return (BufferedReader)TextResource.getResourceAsBufferedReader(this.anchor, (String)this.name, (Charset)encoding).orElseThrow(IOException::new);
    }

    public String copyToString(Charset encoding) throws IOException {
        try (StringWriter writer = new StringWriter();){
            String string;
            block12: {
                BufferedReader reader = this.open(encoding);
                try {
                    int c;
                    while ((c = reader.read()) != -1) {
                        writer.write(c);
                    }
                    string = writer.toString();
                    if (reader == null) break block12;
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                reader.close();
            }
            return string;
        }
    }

    @Generated
    public ResourceId(@lombok.NonNull Class<?> anchor, @lombok.NonNull String name) {
        if (anchor == null) {
            throw new NullPointerException("anchor is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.anchor = anchor;
        this.name = name;
    }

    @lombok.NonNull
    @Generated
    public Class<?> getAnchor() {
        return this.anchor;
    }

    @lombok.NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceId)) {
            return false;
        }
        ResourceId other = (ResourceId)o;
        Class<?> this$anchor = this.getAnchor();
        Class<?> other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : $anchor.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "ResourceId(anchor=" + this.getAnchor() + ", name=" + this.getName() + ")";
    }
}

