/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import internal.io.text.NumberFormats;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalQuery;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;

public final class InternalParser {
    public static <T> T parseTemporalAccessor(DateTimeFormatter formatter, TemporalQuery<T>[] queries, CharSequence input) {
        if (input != null) {
            try {
                switch (queries.length) {
                    case 0: {
                        throw new IllegalArgumentException("At least one query must be specified");
                    }
                    case 1: {
                        return formatter.parse(input, queries[0]);
                    }
                }
                return (T)formatter.parseBest(input, queries);
            }
            catch (DateTimeParseException ex) {
                InternalParser.doNothing(ex);
            }
        }
        return null;
    }

    public static Boolean parseBoolean(CharSequence input) {
        if (input != null) {
            switch (input.toString()) {
                case "true": 
                case "TRUE": 
                case "1": {
                    return Boolean.TRUE;
                }
                case "false": 
                case "FALSE": 
                case "0": {
                    return Boolean.FALSE;
                }
            }
        }
        return null;
    }

    public static Character parseCharacter(CharSequence input) {
        return input != null && input.length() == 1 ? Character.valueOf(input.charAt(0)) : null;
    }

    public static double[] parseDoubleArray(CharSequence input) {
        if (input != null) {
            String tmp = input.toString();
            try {
                int beginIndex = tmp.indexOf(91);
                int endIndex = tmp.lastIndexOf(93);
                if (beginIndex == -1 || endIndex == -1) {
                    return null;
                }
                String[] values = tmp.substring(beginIndex + 1, endIndex).split("\\s*,\\s*");
                double[] result = new double[values.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = Double.parseDouble(values[i].trim());
                }
                return result;
            }
            catch (Exception ex) {
                InternalParser.doNothing(ex);
            }
        }
        return null;
    }

    public static String[] parseStringArray(CharSequence input) {
        if (input != null) {
            String tmp = input.toString();
            try {
                int beginIndex = tmp.indexOf(91);
                int endIndex = tmp.lastIndexOf(93);
                if (beginIndex == -1 || endIndex == -1) {
                    return null;
                }
                String[] values = tmp.substring(beginIndex + 1, endIndex).split("\\s*,\\s*");
                String[] result = new String[values.length];
                for (int i = 0; i < result.length; ++i) {
                    result[i] = values[i].trim();
                }
                return result;
            }
            catch (Exception ex) {
                InternalParser.doNothing(ex);
            }
        }
        return null;
    }

    public static Integer parseInteger(CharSequence input) {
        if (input != null) {
            try {
                return Integer.valueOf(input.toString());
            }
            catch (NumberFormatException ex) {
                InternalParser.doNothing(ex);
            }
        }
        return null;
    }

    public static Long parseLong(CharSequence input) {
        if (input != null) {
            try {
                return Long.valueOf(input.toString());
            }
            catch (NumberFormatException ex) {
                InternalParser.doNothing(ex);
            }
        }
        return null;
    }

    public static Double parseDouble(CharSequence input) {
        if (input != null) {
            try {
                return Double.valueOf(input.toString());
            }
            catch (NumberFormatException ex) {
                InternalParser.doNothing(ex);
            }
        }
        return null;
    }

    public static Charset parseCharset(CharSequence input) {
        if (input != null) {
            try {
                return Charset.forName(input.toString());
            }
            catch (IllegalArgumentException ex) {
                InternalParser.doNothing(ex);
            }
        }
        return null;
    }

    public static File parseFile(CharSequence input) {
        return input != null ? new File(input.toString()) : null;
    }

    public static Date parseDate(DateFormat dateFormat, CharSequence input) {
        if (input != null) {
            String source = input.toString();
            ParsePosition pos = new ParsePosition(0);
            Date result = dateFormat.parse(source, pos);
            return pos.getIndex() == input.length() ? result : null;
        }
        return null;
    }

    public static Number parseNumber(NumberFormat numberFormat, CharSequence input) {
        return input != null ? (Number)NumberFormats.parseAll(numberFormat, NumberFormats.simplify(numberFormat, input)) : (Number)null;
    }

    public static <T extends Enum<T>> T parseEnum(Class<T> enumClass, CharSequence input) {
        if (input != null) {
            try {
                return Enum.valueOf(enumClass, input.toString());
            }
            catch (IllegalArgumentException ex) {
                InternalParser.doNothing(ex);
            }
        }
        return null;
    }

    public static <T> T parse(T[] domain, ToIntFunction<T> function, Integer code) {
        if (code != null) {
            for (T value : domain) {
                if (function.applyAsInt(value) != code.intValue()) continue;
                return value;
            }
        }
        return null;
    }

    public static String parseString(CharSequence input) {
        return input != null ? input.toString() : null;
    }

    public static <T> T parseConstant(T constant, CharSequence input) {
        return constant;
    }

    public static <T> T parseNull(CharSequence input) {
        return null;
    }

    public static List<String> parseStringList(Function<CharSequence, Stream<String>> splitter, CharSequence input) {
        return input != null ? splitter.apply(input).collect(Collectors.toList()) : null;
    }

    public static Locale parseLocale(CharSequence input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return Locale.ROOT;
        }
        String str = input.toString();
        int len = str.length();
        if (len != 2 && len != 5 && len < 7) {
            return null;
        }
        if (!InternalParser.isLocaleLetter(str.charAt(0)) || !InternalParser.isLocaleLetter(str.charAt(1))) {
            return null;
        }
        if (len == 2) {
            return new Locale(str, "");
        }
        if (!InternalParser.isLocaleSeparator(str.charAt(2))) {
            return null;
        }
        char ch3 = str.charAt(3);
        if (InternalParser.isLocaleSeparator(ch3)) {
            return new Locale(str.substring(0, 2), "", str.substring(4));
        }
        char ch4 = str.charAt(4);
        if (!InternalParser.isLocaleLetter(ch3) || !InternalParser.isLocaleLetter(ch4)) {
            return null;
        }
        if (len == 5) {
            return new Locale(str.substring(0, 2), str.substring(3, 5));
        }
        if (!InternalParser.isLocaleSeparator(str.charAt(5))) {
            return null;
        }
        return new Locale(str.substring(0, 2), str.substring(3, 5), str.substring(6));
    }

    private static boolean isLocaleLetter(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isLocaleSeparator(char c) {
        return c == '_' || c == '-';
    }

    public static URL parseURL(CharSequence input) {
        if (input != null) {
            try {
                return new URL(input.toString());
            }
            catch (MalformedURLException ex) {
                InternalParser.doNothing(ex);
            }
        }
        return null;
    }

    public static URI parseURI(CharSequence input) {
        if (input != null) {
            try {
                return new URI(input.toString());
            }
            catch (URISyntaxException ex) {
                InternalParser.doNothing(ex);
            }
        }
        return null;
    }

    public static <T> T parseFailsafe(Function<? super CharSequence, ? extends T> parser, Consumer<? super Throwable> onError, CharSequence input) {
        if (input != null) {
            try {
                return parser.apply(input);
            }
            catch (Throwable ex) {
                onError.accept(ex);
            }
        }
        return null;
    }

    public static void doNothing(Throwable ex) {
    }

    @Generated
    private InternalParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

