/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.function.Function;
import lombok.Generated;
import nbbrd.io.FileFormatter;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.text.TextFormatter;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class WithCharsetFileFormatter<T>
implements FileFormatter<T> {
    @lombok.NonNull
    private final TextFormatter<T> delegate;
    @lombok.NonNull
    private final Charset charset;

    @Override
    public void formatFile(@NonNull T value, @NonNull File target) throws IOException {
        this.delegate.formatFile(value, target, this.charset);
    }

    @Override
    public void formatPath(@NonNull T value, @NonNull Path target) throws IOException {
        this.delegate.formatPath(value, target, this.charset);
    }

    @Override
    public void formatStream(@NonNull T value, @NonNull IOSupplier<? extends OutputStream> target) throws IOException {
        this.delegate.formatStream(value, target, this.charset);
    }

    @Override
    public void formatStream(@NonNull T value, @NonNull OutputStream resource) throws IOException {
        this.delegate.formatStream(value, resource, this.charset);
    }

    @Override
    public <V> @NonNull FileFormatter<V> compose(@NonNull Function<? super V, ? extends T> before) {
        return new WithCharsetFileFormatter<V>(this.delegate.compose(before), this.charset);
    }

    @Generated
    public WithCharsetFileFormatter(@lombok.NonNull TextFormatter<T> delegate, @lombok.NonNull Charset charset) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        this.delegate = delegate;
        this.charset = charset;
    }
}

