/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.function.Function;
import lombok.Generated;
import nbbrd.io.FileParser;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.text.TextParser;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class WithCharsetFileParser<T>
implements FileParser<T> {
    @lombok.NonNull
    private final TextParser<T> delegate;
    @lombok.NonNull
    private final Charset charset;

    @Override
    public @NonNull T parseFile(@NonNull File source) throws IOException {
        return this.delegate.parseFile(source, this.charset);
    }

    @Override
    public @NonNull T parsePath(@NonNull Path source) throws IOException {
        return this.delegate.parsePath(source, this.charset);
    }

    @Override
    public @NonNull T parseResource(@NonNull Class<?> type, @NonNull String name) throws IOException {
        return this.delegate.parseResource(type, name, this.charset);
    }

    @Override
    public @NonNull T parseStream(IOSupplier<? extends InputStream> source) throws IOException {
        return this.delegate.parseStream(source, this.charset);
    }

    @Override
    public @NonNull T parseStream(@NonNull InputStream inputStream) throws IOException {
        return this.delegate.parseStream(inputStream, this.charset);
    }

    @Override
    public <V> @NonNull FileParser<V> andThen(@NonNull Function<? super T, ? extends V> after) {
        return new WithCharsetFileParser<V>(this.delegate.andThen(after), this.charset);
    }

    @Generated
    public WithCharsetFileParser(@lombok.NonNull TextParser<T> delegate, @lombok.NonNull Charset charset) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        this.delegate = delegate;
        this.charset = charset;
    }
}

