/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import nbbrd.io.function.IOConsumer;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IORunnable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Resource {
    public static @NonNull Optional<File> getFile(@NonNull Path path) {
        try {
            return Optional.of(path.toFile());
        }
        catch (UnsupportedOperationException ex) {
            return Optional.empty();
        }
    }

    public static @NonNull Optional<InputStream> getResourceAsStream(@NonNull Class<?> type, @NonNull String name) {
        return Optional.ofNullable(type.getResourceAsStream(name));
    }

    public static void ensureClosed(@NonNull Throwable exception, @Nullable Closeable closeable) {
        Objects.requireNonNull(exception);
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException suppressed) {
                try {
                    exception.addSuppressed(suppressed);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static void closeBoth(@Nullable Closeable first, @Nullable Closeable second) throws IOException {
        if (first != null) {
            try {
                first.close();
            }
            catch (IOException ex) {
                Resource.ensureClosed(ex, second);
                throw ex;
            }
        }
        if (second != null) {
            second.close();
        }
    }

    public static void process(@NonNull URI uri, @NonNull IOConsumer<? super Path> action) throws IOException {
        try {
            action.acceptWithIO(Paths.get(uri));
        }
        catch (FileSystemNotFoundException ex) {
            try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                action.acceptWithIO(fs.provider().getPath(uri));
            }
        }
    }

    @Generated
    private Resource() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static interface Storer<K>
    extends Closeable {
        public void store(@NonNull K var1, @NonNull OutputStream var2) throws IOException, IllegalStateException;
    }

    public static interface Loader<K>
    extends Closeable {
        public @NonNull InputStream load(@NonNull K var1) throws IOException, IllegalStateException;

        public static <K> @NonNull Loader<K> of(@NonNull IOFunction<? super K, ? extends InputStream> loader) {
            return Loader.of(loader, IORunnable.noOp().asCloseable());
        }

        public static <K> @NonNull Loader<K> of(final @NonNull IOFunction<? super K, ? extends InputStream> loader, final @NonNull Closeable closer) {
            Objects.requireNonNull(loader);
            Objects.requireNonNull(closer);
            return new Loader<K>(){
                boolean closed = false;

                @Override
                public InputStream load(K key) throws IOException {
                    Objects.requireNonNull(key);
                    if (this.closed) {
                        throw new IllegalStateException("Closed");
                    }
                    InputStream result = (InputStream)loader.applyWithIO(key);
                    if (result == null) {
                        throw new IOException("Null stream");
                    }
                    return result;
                }

                @Override
                public void close() throws IOException {
                    this.closed = true;
                    closer.close();
                }
            };
        }
    }
}

