/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import internal.io.text.ComposeTextFormatter;
import internal.io.text.FunctionalTextFormatter;
import internal.io.text.LegacyFiles;
import internal.io.text.WithCharsetFileFormatter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import nbbrd.io.FileFormatter;
import nbbrd.io.Resource;
import nbbrd.io.function.IOBiConsumer;
import nbbrd.io.function.IOSupplier;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface TextFormatter<T> {
    default public @NonNull String formatToString(@NonNull T value) throws IOException {
        Objects.requireNonNull(value, "value");
        StringWriter writer = new StringWriter();
        this.formatWriter(value, writer);
        return writer.toString();
    }

    default public void formatChars(@NonNull T value, @NonNull Appendable target) throws IOException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(target, "target");
        StringWriter writer = new StringWriter();
        this.formatWriter(value, writer);
        target.append(writer.getBuffer());
    }

    default public void formatFile(@NonNull T value, @NonNull File target, @NonNull Charset encoding) throws IOException {
        Objects.requireNonNull(value, "value");
        LegacyFiles.checkTarget(target);
        Objects.requireNonNull(encoding, "encoding");
        this.formatStream(value, () -> LegacyFiles.newOutputStream(target), encoding);
    }

    default public void formatPath(@NonNull T value, @NonNull Path target, @NonNull Charset encoding) throws IOException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(target, "target");
        Objects.requireNonNull(encoding, "encoding");
        Optional<File> file = Resource.getFile(target);
        if (file.isPresent()) {
            this.formatFile(value, file.get(), encoding);
        } else {
            this.formatStream(value, () -> Files.newOutputStream(target, new OpenOption[0]), encoding);
        }
    }

    default public void formatWriter(@NonNull T value, IOSupplier<? extends Writer> target) throws IOException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(target, "target");
        try (Writer resource = LegacyFiles.checkResource(target.getWithIO(), "Missing Writer");){
            this.formatWriter(value, resource);
        }
    }

    default public void formatStream(@NonNull T value, IOSupplier<? extends OutputStream> target, @NonNull Charset encoding) throws IOException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(target, "target");
        Objects.requireNonNull(encoding, "encoding");
        try (OutputStream resource = LegacyFiles.checkResource(target.getWithIO(), "Missing OutputStream");){
            this.formatStream(value, resource, encoding);
        }
    }

    public void formatWriter(@NonNull T var1, @NonNull Writer var2) throws IOException;

    public void formatStream(@NonNull T var1, @NonNull OutputStream var2, @NonNull Charset var3) throws IOException;

    default public <V> @NonNull TextFormatter<V> compose(@NonNull Function<? super V, ? extends T> before) {
        return new ComposeTextFormatter<V, T>(this, before);
    }

    default public @NonNull FileFormatter<T> withCharset(@NonNull Charset encoding) {
        return new WithCharsetFileFormatter(this, encoding);
    }

    public static <T> @NonNull TextFormatter<T> onFormattingWriter(@NonNull IOBiConsumer<? super T, ? super Writer> function) {
        return new FunctionalTextFormatter<T>(function);
    }
}

