/*
 * Decompiled with CFR 0.152.
 */
package internal.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Objects;
import lombok.Generated;
import nbbrd.io.FileFormatter;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.function.IOUnaryOperator;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class EncodingFileFormatter<T>
implements FileFormatter<T> {
    @lombok.NonNull
    final FileFormatter<T> formatter;
    @lombok.NonNull
    final IOUnaryOperator<OutputStream> encoder;

    @Override
    public void formatFile(@NonNull T value, @NonNull File target) throws IOException {
        FileFormatter.super.formatFile(value, target);
    }

    @Override
    public void formatPath(@NonNull T value, @NonNull Path target) throws IOException {
        FileFormatter.super.formatPath(value, target);
    }

    @Override
    public void formatStream(@NonNull T value, @NonNull IOSupplier<? extends OutputStream> target) throws IOException {
        FileFormatter.super.formatStream(value, target);
    }

    @Override
    public void formatStream(@NonNull T value, @NonNull OutputStream resource) throws IOException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(resource, "resource");
        try (OutputStream encoding = (OutputStream)this.encoder.applyWithIO(resource);){
            this.formatter.formatStream(value, encoding);
        }
    }

    @Generated
    public EncodingFileFormatter(@lombok.NonNull FileFormatter<T> formatter, @lombok.NonNull IOUnaryOperator<OutputStream> encoder) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        if (encoder == null) {
            throw new NullPointerException("encoder is marked non-null but is null");
        }
        this.formatter = formatter;
        this.encoder = encoder;
    }
}

