/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Objects;
import lombok.Generated;
import nbbrd.io.function.IOBiConsumer;
import nbbrd.io.text.TextFormatter;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class FunctionalTextFormatter<T>
implements TextFormatter<T> {
    @lombok.NonNull
    private final IOBiConsumer<? super T, ? super Writer> function;

    @Override
    public void formatWriter(@NonNull T value, @NonNull Writer resource) throws IOException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(resource, "resource");
        this.function.acceptWithIO(value, resource);
    }

    @Override
    public void formatStream(@NonNull T value, @NonNull OutputStream resource, @NonNull Charset encoding) throws IOException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(resource, "resource");
        Objects.requireNonNull(encoding, "encoding");
        try (OutputStreamWriter writer = new OutputStreamWriter(resource, encoding);){
            this.formatWriter(value, writer);
        }
    }

    @Generated
    public FunctionalTextFormatter(@lombok.NonNull IOBiConsumer<? super T, ? super Writer> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        this.function = function;
    }
}

