/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import nbbrd.io.text.BaseProperty;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class DoubleProperty
extends BaseProperty {
    @lombok.NonNull
    private final String key;
    private final double defaultValue;

    public double get(@NonNull Function<? super String, ? extends CharSequence> properties) {
        CharSequence value = properties.apply(this.key);
        if (value == null) {
            return this.defaultValue;
        }
        Double result = Parser.onDouble().parse(value);
        return result != null ? result : this.defaultValue;
    }

    public double get(@NonNull Properties properties) {
        return this.get(properties::getProperty);
    }

    public double get(@NonNull Map<String, String> properties) {
        return this.get(properties::get);
    }

    public void set(@NonNull BiConsumer<? super String, ? super String> properties, double value) {
        String valueAsString;
        Objects.requireNonNull(properties);
        if (value != this.defaultValue && (valueAsString = Formatter.onDouble().formatAsString(value)) != null) {
            properties.accept(this.key, valueAsString);
        }
    }

    public void set(@NonNull Properties properties, double value) {
        this.set(properties::setProperty, value);
    }

    public void set(@NonNull Map<String, String> properties, double value) {
        this.set(properties::put, value);
    }

    @Generated
    private DoubleProperty(@lombok.NonNull String key, double defaultValue) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        this.defaultValue = defaultValue;
    }

    @Generated
    public static @NonNull DoubleProperty of(@lombok.NonNull String key, double defaultValue) {
        return new DoubleProperty(key, defaultValue);
    }

    @Override
    @lombok.NonNull
    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public double getDefaultValue() {
        return this.defaultValue;
    }
}

