/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.text;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TextResource {
    public static @NonNull Optional<BufferedReader> getResourceAsBufferedReader(@NonNull Class<?> anchor, @NonNull String name, @NonNull Charset charset) {
        Objects.requireNonNull(charset);
        return Optional.ofNullable(anchor.getResourceAsStream(name)).map(stream -> new BufferedReader(new InputStreamReader((InputStream)stream, charset)));
    }

    public static @NonNull BufferedReader newBufferedReader(@NonNull InputStream stream, @NonNull CharsetDecoder decoder) {
        return new BufferedReader(new InputStreamReader(stream, decoder));
    }

    public static @NonNull BufferedWriter newBufferedWriter(@NonNull OutputStream stream, @NonNull CharsetEncoder encoder) {
        return new BufferedWriter(new OutputStreamWriter(stream, encoder));
    }

    @Generated
    private TextResource() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

