/*
 * Decompiled with CFR 0.152.
 */
package _test.io.text;

import _test.io.CountingIOSupplier;
import _test.io.CountingInputStream;
import _test.io.ResourceId;
import _test.io.Util;
import com.google.common.jimfs.Configuration;
import com.google.common.jimfs.Jimfs;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystem;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.text.TextParser;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssertAlternative;

public final class TextParserAssertions {
    public static <T> void assertTextParserCompliance(@NonNull Path temp, @NonNull TextParser<T> p, @NonNull T value, @NonNull Function<Charset, ResourceId> expected, @NonNull Collection<Charset> encodings, boolean allowEmpty) throws IOException {
        if (temp == null) {
            throw new NullPointerException("temp is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        if (encodings == null) {
            throw new NullPointerException("encodings is marked non-null but is null");
        }
        Util.checkDefaultProvider(temp);
        TextParserAssertions.testParseChars(p, value, expected);
        TextParserAssertions.testParseFileCharset(p, temp, value, expected, encodings, allowEmpty);
        TextParserAssertions.testParsePathCharset(p, temp, value, expected, encodings, allowEmpty);
        TextParserAssertions.testParseResourceCharset(p, value, expected);
        TextParserAssertions.testParseReaderFromSupplier(p, value, expected);
        TextParserAssertions.testParseStreamFromSupplierCharset(p, value, expected);
        TextParserAssertions.testParseReader(p, value, expected);
        TextParserAssertions.testParseStreamCharset(p, value, expected);
    }

    private static <T> void testParseChars(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseChars(null)).withMessageContaining("source");
        String chars = expected.apply(StandardCharsets.UTF_8).copyToString(StandardCharsets.UTF_8);
        Assertions.assertThat((Object)p.parseChars((CharSequence)chars)).isEqualTo(value);
    }

    private static <T> void testParseFileCharset(TextParser<T> p, Path temp, T value, Function<Charset, ResourceId> expected, Collection<Charset> encodings, boolean allowEmpty) throws IOException {
        File nonNullSource = Util.newEmptyFile(temp).toFile();
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        FileTime refTime = Util.lastAccessTime(nonNullSource.toPath());
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseFile(null, nonNullEncoding)).withMessageContaining("source");
        Assertions.assertThat((Comparable)Util.lastAccessTime(nonNullSource.toPath())).isEqualTo((Object)refTime);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseFile(nonNullSource, null)).withMessageContaining("encoding");
        Assertions.assertThat((Comparable)Util.lastAccessTime(nonNullSource.toPath())).isEqualTo((Object)refTime);
        if (!allowEmpty) {
            File emptyFile = Util.newEmptyFile(temp).toFile();
            ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(emptyFile, StandardCharsets.UTF_8)).isInstanceOf(EOFException.class)).withMessageContaining(emptyFile.toString());
        }
        File missingFile = Util.newFile(temp).toFile();
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(missingFile, StandardCharsets.UTF_8)).isInstanceOf(NoSuchFileException.class)).withMessageContaining(missingFile.toString());
        File dir = Util.newDir(temp).toFile();
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(dir, StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        for (Charset encoding : encodings) {
            File file = expected.apply(encoding).copyTo(temp).toFile();
            Assertions.assertThat((Object)p.parseFile(file, encoding)).isEqualTo(value);
        }
    }

    private static <T> void testParsePathCharset(TextParser<T> p, Path temp, T value, Function<Charset, ResourceId> expected, Collection<Charset> encodings, boolean allowEmpty) throws IOException {
        Path nonNullSource = Util.newEmptyFile(temp);
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        FileTime refTime = Util.lastAccessTime(nonNullSource);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parsePath(null, nonNullEncoding)).withMessageContaining("source");
        Assertions.assertThat((Comparable)Util.lastAccessTime(nonNullSource)).isEqualTo((Object)refTime);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parsePath(nonNullSource, null)).withMessageContaining("encoding");
        Assertions.assertThat((Comparable)Util.lastAccessTime(nonNullSource)).isEqualTo((Object)refTime);
        if (!allowEmpty) {
            Path emptyFile = Util.newEmptyFile(temp);
            ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(emptyFile, StandardCharsets.UTF_8)).isInstanceOf(EOFException.class)).withMessageContaining(emptyFile.toString());
        }
        Path missingFile = Util.newFile(temp);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(missingFile, StandardCharsets.UTF_8)).isInstanceOf(NoSuchFileException.class)).withMessageContaining(missingFile.toString());
        Path dir = Util.newDir(temp);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(dir, StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        try (FileSystem inMemoryFS = Jimfs.newFileSystem((Configuration)Configuration.unix());){
            for (Charset encoding : encodings) {
                ResourceId id = expected.apply(encoding);
                for (Path target : Arrays.asList(id.copyTo(temp), id.copyTo(inMemoryFS.getPath("/", new String[0])))) {
                    Assertions.assertThat((Object)p.parsePath(target, encoding)).isEqualTo(value);
                }
            }
        }
    }

    private static <T> void testParseResourceCharset(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        Class<TextParserAssertions> nonNullType = TextParserAssertions.class;
        String nonNullName = "";
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(null, nonNullName, nonNullEncoding)).withMessageContaining("type");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(nonNullType, null, nonNullEncoding)).withMessageContaining("name");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(nonNullType, nonNullName, null)).withMessageContaining("encoding");
        String missingResource = UUID.randomUUID().toString();
        Assertions.assertThatIOException().isThrownBy(() -> p.parseResource(TextParserAssertions.class, missingResource, StandardCharsets.UTF_8)).withMessageContaining("Missing").withMessageContaining(missingResource).withMessageContaining(TextParserAssertions.class.getName());
        ResourceId resourceId = expected.apply(StandardCharsets.UTF_8);
        Assertions.assertThat((Object)p.parseResource(resourceId.getAnchor(), resourceId.getName(), StandardCharsets.UTF_8)).isEqualTo(value);
    }

    private static <T> void testParseReaderFromSupplier(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseReader((IOSupplier)null)).withMessageContaining("source");
        Assertions.assertThat((Object)p.parseReader(() -> ((ResourceId)expected.apply(StandardCharsets.UTF_8)).open(StandardCharsets.UTF_8))).isEqualTo(value);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseReader(IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing Reader");
        Assertions.assertThatIOException().isThrownBy(() -> p.parseReader(Util.failingSupplier(() -> new TextParserTestError()))).isInstanceOf(TextParserTestError.class);
    }

    private static <T> void testParseStreamFromSupplierCharset(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        CountingIOSupplier nonNullSource = new CountingIOSupplier(Util::emptyInputStream);
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((IOSupplier)null, nonNullEncoding)).withMessageContaining("source");
        Assertions.assertThat((int)nonNullSource.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((IOSupplier)nonNullSource, null)).withMessageContaining("encoding");
        Assertions.assertThat((int)nonNullSource.getCount()).isEqualTo(0);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseStream(IOSupplier.of(null), StandardCharsets.UTF_8)).isInstanceOf(IOException.class)).withMessageContaining("Missing InputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.parseStream(Util.failingSupplier(() -> new TextParserTestError()), StandardCharsets.UTF_8)).isInstanceOf(TextParserTestError.class);
        Assertions.assertThat((Object)p.parseStream(() -> ((ResourceId)expected.apply(StandardCharsets.UTF_8)).open(), StandardCharsets.UTF_8)).isEqualTo(value);
    }

    private static <T> void testParseReader(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseReader((Reader)null)).withMessageContaining("resource");
        try (BufferedReader resource = expected.apply(StandardCharsets.UTF_8).open(StandardCharsets.UTF_8);){
            Assertions.assertThat((Object)p.parseReader((Reader)resource)).isEqualTo(value);
        }
    }

    private static <T> void testParseStreamCharset(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        CountingInputStream nonNullSource = new CountingInputStream(Util.emptyInputStream());
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((InputStream)null, nonNullEncoding)).withMessageContaining("resource");
        Assertions.assertThat((int)nonNullSource.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((InputStream)nonNullSource, null)).withMessageContaining("encoding");
        Assertions.assertThat((int)nonNullSource.getCount()).isEqualTo(0);
        try (InputStream resource = expected.apply(StandardCharsets.UTF_8).open();){
            Assertions.assertThat((Object)p.parseStream(resource, StandardCharsets.UTF_8)).isEqualTo(value);
        }
    }

    private static final class TextParserTestError
    extends IOException {
        private TextParserTestError() {
        }
    }
}

