/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import lombok.Generated;
import lombok.NonNull;

public final class LegacyFiles {
    @NonNull
    public static InputStream newInputStream(@NonNull File source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return new BufferedFileInputStream(source);
    }

    @NonNull
    public static OutputStream newOutputStream(@NonNull File target) throws IOException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return new BufferedOutputStream(new FileOutputStream(target));
    }

    public static void checkSource(@NonNull File source) throws FileSystemException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        LegacyFiles.checkExist(source);
        LegacyFiles.checkIsFile(source);
    }

    public static void checkTarget(@NonNull File target) throws FileSystemException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (target.exists()) {
            LegacyFiles.checkIsFile(target);
        }
    }

    public static void checkExist(@NonNull File source) throws FileSystemException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (!source.exists()) {
            throw new NoSuchFileException(source.getPath());
        }
    }

    public static void checkIsFile(@NonNull File source) throws FileSystemException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (!source.isFile()) {
            throw new AccessDeniedException(source.getPath());
        }
    }

    public static String toSystemId(File file) {
        return file.toURI().toASCIIString();
    }

    public static File fromSystemId(String systemId) {
        try {
            return new File(URI.create(systemId));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <T extends Closeable> T checkResource(T resource, String message) throws IOException {
        if (resource == null) {
            throw new IOException(message);
        }
        return resource;
    }

    @Generated
    private LegacyFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class BufferedFileInputStream
    extends BufferedInputStream {
        private final File file;

        public BufferedFileInputStream(File source) throws FileNotFoundException {
            super(new FileInputStream(source));
            this.file = source;
        }

        public File getFile() {
            return this.file;
        }
    }
}

