/*
 * Decompiled with CFR 0.152.
 */
package internal.io.text;

import internal.io.text.BufferedInputStreamWithFile;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.NoSuchFileException;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.function.IOSupplier;

public final class LegacyFiles {
    public static InputStream openResource(Class<?> anchor, String name) throws IOException {
        return Resource.getResourceAsStream(anchor, name).orElseThrow(() -> new IOException("Missing resource '" + name + "' of '" + anchor.getName() + "'"));
    }

    public static Reader openReader(CharSequence source) {
        return new StringReader(source.toString());
    }

    public static Reader openReader(IOSupplier<? extends Reader> source) throws IOException {
        return LegacyFiles.checkResource(source.getWithIO(), "Missing Reader");
    }

    public static InputStream openInputStream(IOSupplier<? extends InputStream> source) throws IOException {
        return LegacyFiles.checkResource(source.getWithIO(), "Missing InputStream");
    }

    @NonNull
    public static InputStream openInputStream(@NonNull File source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return new BufferedInputStreamWithFile(LegacyFiles.checkSource(source));
    }

    public static Writer openWriter(IOSupplier<? extends Writer> source) throws IOException {
        return LegacyFiles.checkResource(source.getWithIO(), "Missing Writer");
    }

    public static OutputStream openOutputStream(IOSupplier<? extends OutputStream> source) throws IOException {
        return LegacyFiles.checkResource(source.getWithIO(), "Missing OutputStream");
    }

    @NonNull
    public static OutputStream openOutputStream(@NonNull File target) throws IOException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        return new BufferedOutputStream(new FileOutputStream(LegacyFiles.checkTarget(target)));
    }

    public static File checkSource(@NonNull File source) throws FileSystemException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        LegacyFiles.checkExist(source);
        LegacyFiles.checkIsFile(source);
        return source;
    }

    public static File checkTarget(@NonNull File target) throws FileSystemException {
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        if (target.exists()) {
            LegacyFiles.checkIsFile(target);
        }
        return target;
    }

    public static void checkExist(@NonNull File source) throws FileSystemException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (!source.exists()) {
            throw new NoSuchFileException(source.getPath());
        }
    }

    public static void checkIsFile(@NonNull File source) throws FileSystemException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (!source.isFile()) {
            throw new AccessDeniedException(source.getPath());
        }
    }

    public static String toSystemId(File file) {
        return file.toURI().toASCIIString();
    }

    public static File fromSystemId(String systemId) {
        try {
            return new File(URI.create(systemId));
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    private static <T extends Closeable> T checkResource(T resource, String message) throws IOException {
        if (resource == null) {
            throw new IOException(message);
        }
        return resource;
    }

    @Generated
    private LegacyFiles() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

