/*
 * Decompiled with CFR 0.152.
 */
package internal.io;

import internal.io.text.FileSystemExceptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.FileParser;
import nbbrd.io.function.IOSupplier;

public final class LockingFileParser<T>
implements FileParser<T> {
    @NonNull
    private final FileParser<T> delegate;

    @Override
    @NonNull
    public T parseFile(@NonNull File source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (FileInputStream stream = new FileInputStream(FileSystemExceptions.checkSource(source));){
            T t;
            block12: {
                FileLock ignore = stream.getChannel().lock(0L, Long.MAX_VALUE, true);
                try {
                    t = this.delegate.parseStream(stream);
                    if (ignore == null) break block12;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
            }
            return t;
        }
    }

    @Override
    @NonNull
    public T parsePath(@NonNull Path source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (FileChannel channel = FileChannel.open(FileSystemExceptions.checkSource(source), StandardOpenOption.READ);){
            T t;
            block13: {
                FileLock ignore = channel.lock(0L, Long.MAX_VALUE, true);
                try {
                    t = this.delegate.parseStream(Channels.newInputStream(channel));
                    if (ignore == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ignore.close();
            }
            return t;
        }
    }

    @Override
    @NonNull
    public T parseResource(@NonNull Class<?> type, @NonNull String name) throws IOException {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.delegate.parseResource(type, name);
    }

    @Override
    @NonNull
    public T parseStream(@NonNull IOSupplier<? extends InputStream> source) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        return this.delegate.parseStream(source);
    }

    @Override
    @NonNull
    public T parseStream(@NonNull InputStream resource) throws IOException {
        if (resource == null) {
            throw new NullPointerException("resource is marked non-null but is null");
        }
        return this.delegate.parseStream(resource);
    }

    @Generated
    public LockingFileParser(@NonNull FileParser<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        this.delegate = delegate;
    }
}

