/*
 * Decompiled with CFR 0.152.
 */
package _test.io;

import _test.io.CountingIOSupplier;
import _test.io.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.FileFormatter;
import nbbrd.io.function.IOSupplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowableAssertAlternative;

public final class FileFormatterAssertions {
    public static <T> void assertFileFormatterCompliance(@NonNull Path temp, @NonNull FileFormatter<T> p, @NonNull T value, @NonNull byte[] expected) throws IOException {
        if (temp == null) {
            throw new NullPointerException("temp is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        Util.checkDefaultProvider(temp);
        FileFormatterAssertions.testFormatFile(p, value, expected, temp);
        FileFormatterAssertions.testFormatPath(p, value, expected, temp);
        FileFormatterAssertions.testFormatStreamFromSupplier(p, value, expected);
        FileFormatterAssertions.testFormatStream(p, value, expected);
    }

    private static <T> void testFormatFile(FileFormatter<T> p, T value, byte[] expected, Path temp) throws IOException {
        File nonNullTarget = Util.newFile(temp).toFile();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(null, nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((File)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(value, null)).withMessageContaining("target");
        Assertions.assertThat((File)nonNullTarget).doesNotExist();
        File dir = Util.newDir(temp).toFile();
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatFile(value, dir)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        File target = Util.newFile(temp).toFile();
        p.formatFile(value, target);
        Assertions.assertThat((File)target).exists().isFile().hasBinaryContent(expected);
    }

    private static <T> void testFormatPath(FileFormatter<T> p, T value, byte[] expected, Path temp) throws IOException {
        Path nonNullTarget = Util.newFile(temp);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(null, nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((Path)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(value, null)).withMessageContaining("target");
        Assertions.assertThat((Path)nonNullTarget).doesNotExist();
        Path dir = Util.newDir(temp);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatPath(value, dir)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        Path target = Util.newFile(temp);
        p.formatPath(value, target);
        Assertions.assertThat((Path)target).exists().isReadable().hasBinaryContent(expected);
    }

    private static <T> void testFormatStreamFromSupplier(FileFormatter<T> p, T value, byte[] expected) throws IOException {
        CountingIOSupplier nonNullTarget = new CountingIOSupplier(ByteArrayOutputStream::new);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, (IOSupplier)nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (IOSupplier)null)).withMessageContaining("target");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatStream(value, IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing OutputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.formatStream(value, Util.failingSupplier(() -> new FileFormatterTestError()))).isInstanceOf(FileFormatterTestError.class);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        p.formatStream(value, () -> stream);
        Assertions.assertThat((byte[])stream.toByteArray()).isEqualTo((Object)expected);
    }

    private static <T> void testFormatStream(FileFormatter<T> p, T value, byte[] expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (OutputStream)null)).withMessageContaining("resource");
        try (CloseableOutputStream stream = new CloseableOutputStream();){
            Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, (OutputStream)stream)).withMessageContaining("value");
            ((ObjectAssert)Assertions.assertThat((Object)stream).returns((Object)0, ByteArrayOutputStream::size)).returns((Object)false, CloseableOutputStream::isClosed);
        }
        stream = new CloseableOutputStream();
        try {
            p.formatStream(value, (OutputStream)stream);
            ((ObjectAssert)Assertions.assertThat((Object)stream).returns((Object)expected, ByteArrayOutputStream::toByteArray)).returns((Object)false, CloseableOutputStream::isClosed);
        }
        finally {
            stream.close();
        }
    }

    private static final class FileFormatterTestError
    extends IOException {
        private FileFormatterTestError() {
        }
    }

    private static final class CloseableOutputStream
    extends ByteArrayOutputStream {
        private boolean closed = false;

        @Override
        public synchronized void reset() {
            this.closed = false;
            super.reset();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        @Generated
        public CloseableOutputStream() {
        }

        @Generated
        public boolean isClosed() {
            return this.closed;
        }
    }
}

