/*
 * Decompiled with CFR 0.152.
 */
package _test.io;

import _test.io.ResourceId;
import _test.io.Util;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.FileParser;
import nbbrd.io.function.IOSupplier;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssertAlternative;

public final class FileParserAssertions {
    public static <T> void assertFileParserCompliance(@NonNull Path temp, @NonNull FileParser<T> p, @NonNull T value, @NonNull ResourceId expected, boolean allowEmpty) throws IOException {
        if (temp == null) {
            throw new NullPointerException("temp is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        Util.checkDefaultProvider(temp);
        FileParserAssertions.testParseFile(p, temp, value, expected, allowEmpty);
        FileParserAssertions.testParsePath(p, temp, value, expected, allowEmpty);
        FileParserAssertions.testParseResource(p, value, expected);
        FileParserAssertions.testParseStream(p, value, expected);
        FileParserAssertions.testParseStreamFromSupplier(p, value, expected);
    }

    private static <T> void testParseFile(FileParser<T> p, Path temp, T value, ResourceId expected, boolean allowEmpty) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseFile(null)).withMessageContaining("source");
        if (!allowEmpty) {
            File emptyFile = Util.newEmptyFile(temp).toFile();
            ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(emptyFile)).isInstanceOf(EOFException.class)).withMessageContaining(emptyFile.toString());
        }
        File missingFile = Util.newFile(temp).toFile();
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(missingFile)).isInstanceOf(NoSuchFileException.class)).withMessageContaining(missingFile.toString());
        File dir = Util.newDir(temp).toFile();
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(dir)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        File file = expected.copyTo(temp).toFile();
        Assertions.assertThat((Object)p.parseFile(file)).isEqualTo(value);
    }

    private static <T> void testParsePath(FileParser<T> p, Path temp, T value, ResourceId expected, boolean allowEmpty) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parsePath(null)).withMessageContaining("source");
        if (!allowEmpty) {
            Path emptyFile = Util.newEmptyFile(temp);
            ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(emptyFile)).isInstanceOf(EOFException.class)).withMessageContaining(emptyFile.toString());
        }
        Path missingFile = Util.newFile(temp);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(missingFile)).isInstanceOf(NoSuchFileException.class)).withMessageContaining(missingFile.toString());
        Path dir = Util.newDir(temp);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(dir)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        Path target = expected.copyTo(temp);
        Assertions.assertThat((Object)p.parsePath(target)).isEqualTo(value);
    }

    private static <T> void testParseResource(FileParser<T> p, T value, ResourceId expected) throws IOException {
        Class<FileParserAssertions> nonNullType = FileParserAssertions.class;
        String nonNullName = "";
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(null, nonNullName)).withMessageContaining("type");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(nonNullType, null)).withMessageContaining("name");
        String missingResource = UUID.randomUUID().toString();
        Assertions.assertThatIOException().isThrownBy(() -> p.parseResource(FileParserAssertions.class, missingResource)).withMessageContaining("Missing").withMessageContaining(missingResource).withMessageContaining(FileParserAssertions.class.getName());
        Assertions.assertThat((Object)p.parseResource(expected.getAnchor(), expected.getName())).isEqualTo(value);
    }

    private static <T> void testParseStreamFromSupplier(FileParser<T> p, T value, ResourceId expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((IOSupplier)null)).withMessageContaining("source");
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseStream(IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing InputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.parseStream(Util.failingSupplier(() -> new FileParserTestError()))).isInstanceOf(FileParserTestError.class);
        Assertions.assertThat((Object)p.parseStream(expected::open)).isEqualTo(value);
    }

    private static <T> void testParseStream(FileParser<T> p, T value, ResourceId expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((InputStream)null)).withMessageContaining("resource");
        byte[] bytes = expected.toBytes();
        try (CloseableInputStream resource = new CloseableInputStream(bytes);){
            Assertions.assertThat((Object)p.parseStream((InputStream)resource)).isEqualTo(value);
            Assertions.assertThat((boolean)resource.isClosed()).isFalse();
        }
    }

    private static final class FileParserTestError
    extends IOException {
        private FileParserTestError() {
        }
    }

    private static final class CloseableInputStream
    extends ByteArrayInputStream {
        private boolean closed = false;

        public CloseableInputStream(byte[] bytes) {
            super(bytes);
        }

        @Override
        public synchronized void reset() {
            this.closed = false;
            super.reset();
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            super.close();
        }

        @Generated
        public boolean isClosed() {
            return this.closed;
        }
    }
}

