/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io;

import internal.io.IOIterators;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.NonNull;
import nbbrd.io.function.IOConsumer;
import nbbrd.io.function.IOPredicate;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.function.IOUnaryOperator;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface IOIterator<E> {
    public boolean hasNextWithIO() throws IOException;

    public @Nullable E nextWithIO() throws IOException, NoSuchElementException;

    default public void removeWithIO() throws IOException {
        throw new UnsupportedOperationException("remove");
    }

    default public void forEachRemainingWithIO(@NonNull IOConsumer<? super E> action) throws IOException {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        while (this.hasNextWithIO()) {
            action.acceptWithIO(this.nextWithIO());
        }
    }

    @NonNull
    default public Stream<E> asStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.asUnchecked(), 0), false);
    }

    @NonNull
    default public Iterator<E> asUnchecked() {
        return new IOIterators.Unchecked(this);
    }

    @NonNull
    public static <E> IOIterator<E> empty() {
        return IOIterators.Empty.INSTANCE;
    }

    @NonNull
    public static <E> IOIterator<E> singleton(@NonNull E element) {
        if (element == null) {
            throw new NullPointerException("element is marked non-null but is null");
        }
        return new IOIterators.Singleton<E>(element);
    }

    @NonNull
    public static <E> IOIterator<E> checked(@NonNull Iterator<E> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        return iterator instanceof IOIterators.Unchecked ? ((IOIterators.Unchecked)iterator).getDelegate() : new IOIterators.Checked<E>(iterator);
    }

    @NonNull
    public static <E> Iterator<E> unchecked(@NonNull IOIterator<E> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator is marked non-null but is null");
        }
        return iterator instanceof IOIterators.Checked ? ((IOIterators.Checked)iterator).getDelegate() : new IOIterators.Unchecked<E>(iterator);
    }

    @NonNull
    public static <E> IOIterator<E> iterate(@NonNull IOSupplier<E> seed, @NonNull IOPredicate<? super E> hasNext, @NonNull IOUnaryOperator<E> next) {
        if (seed == null) {
            throw new NullPointerException("seed is marked non-null but is null");
        }
        if (hasNext == null) {
            throw new NullPointerException("hasNext is marked non-null but is null");
        }
        if (next == null) {
            throw new NullPointerException("next is marked non-null but is null");
        }
        return new IOIterators.Functional<E>(seed, hasNext, next);
    }

    @NonNull
    public static <E> IOIterator<E> generateWhile(@NonNull IOSupplier<E> supplier, @NonNull IOPredicate<? super E> predicate) {
        if (supplier == null) {
            throw new NullPointerException("supplier is marked non-null but is null");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        return IOIterator.iterate(supplier, predicate, value -> supplier.getWithIO());
    }
}

