/*
 * Decompiled with CFR 0.152.
 */
package _test.io;

import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IteratorFactory<E>
implements Supplier<Iterator<E>> {
    @lombok.NonNull
    private final Supplier<E> seed;
    @lombok.NonNull
    private final Predicate<? super E> hasNext;
    @lombok.NonNull
    private final UnaryOperator<E> next;
    @lombok.NonNull
    private final Runnable remove;

    @Override
    public Iterator<E> get() {
        return new Iterator<E>(){
            E current;
            {
                this.current = IteratorFactory.this.seed.get();
            }

            @Override
            public boolean hasNext() {
                return IteratorFactory.this.hasNext.test(this.current);
            }

            @Override
            public E next() {
                this.current = IteratorFactory.this.next.apply(this.current);
                return this.current;
            }

            @Override
            public void remove() {
                IteratorFactory.this.remove.run();
            }
        };
    }

    public static void drainForEach(Iterator<?> iter) {
        iter.forEachRemaining(o -> iter.remove());
    }

    public static void drainNext(Iterator<?> iter) {
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    public static void browseNext(Iterator<?> iterator) {
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    @Generated
    public IteratorFactory(@lombok.NonNull Supplier<E> seed, @lombok.NonNull Predicate<? super E> hasNext, @lombok.NonNull UnaryOperator<E> next, @lombok.NonNull Runnable remove) {
        if (seed == null) {
            throw new NullPointerException("seed is marked non-null but is null");
        }
        if (hasNext == null) {
            throw new NullPointerException("hasNext is marked non-null but is null");
        }
        if (next == null) {
            throw new NullPointerException("next is marked non-null but is null");
        }
        if (remove == null) {
            throw new NullPointerException("remove is marked non-null but is null");
        }
        this.seed = seed;
        this.hasNext = hasNext;
        this.next = next;
        this.remove = remove;
    }

    @lombok.NonNull
    @Generated
    public Supplier<E> getSeed() {
        return this.seed;
    }

    @lombok.NonNull
    @Generated
    public Predicate<? super E> getHasNext() {
        return this.hasNext;
    }

    @lombok.NonNull
    @Generated
    public UnaryOperator<E> getNext() {
        return this.next;
    }

    @lombok.NonNull
    @Generated
    public Runnable getRemove() {
        return this.remove;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IteratorFactory)) {
            return false;
        }
        IteratorFactory other = (IteratorFactory)o;
        Supplier<E> this$seed = this.getSeed();
        Supplier<E> other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !this$seed.equals(other$seed)) {
            return false;
        }
        Predicate<E> this$hasNext = this.getHasNext();
        Predicate<E> other$hasNext = other.getHasNext();
        if (this$hasNext == null ? other$hasNext != null : !this$hasNext.equals(other$hasNext)) {
            return false;
        }
        UnaryOperator<E> this$next = this.getNext();
        UnaryOperator<E> other$next = other.getNext();
        if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
            return false;
        }
        Runnable this$remove = this.getRemove();
        Runnable other$remove = other.getRemove();
        return !(this$remove == null ? other$remove != null : !this$remove.equals(other$remove));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<E> $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : $seed.hashCode());
        Predicate<E> $hasNext = this.getHasNext();
        result = result * 59 + ($hasNext == null ? 43 : $hasNext.hashCode());
        UnaryOperator<E> $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : $next.hashCode());
        Runnable $remove = this.getRemove();
        result = result * 59 + ($remove == null ? 43 : $remove.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "IteratorFactory(seed=" + String.valueOf(this.getSeed()) + ", hasNext=" + String.valueOf(this.getHasNext()) + ", next=" + String.valueOf(this.getNext()) + ", remove=" + String.valueOf(this.getRemove()) + ")";
    }

    @Generated
    public @NonNull IteratorFactory<E> withSeed(@lombok.NonNull Supplier<E> seed) {
        if (seed == null) {
            throw new NullPointerException("seed is marked non-null but is null");
        }
        return this.seed == seed ? this : new IteratorFactory<E>(seed, this.hasNext, this.next, this.remove);
    }

    @Generated
    public @NonNull IteratorFactory<E> withHasNext(@lombok.NonNull Predicate<? super E> hasNext) {
        if (hasNext == null) {
            throw new NullPointerException("hasNext is marked non-null but is null");
        }
        return this.hasNext == hasNext ? this : new IteratorFactory<E>(this.seed, hasNext, this.next, this.remove);
    }

    @Generated
    public @NonNull IteratorFactory<E> withNext(@lombok.NonNull UnaryOperator<E> next) {
        if (next == null) {
            throw new NullPointerException("next is marked non-null but is null");
        }
        return this.next == next ? this : new IteratorFactory<E>(this.seed, this.hasNext, next, this.remove);
    }

    @Generated
    public @NonNull IteratorFactory<E> withRemove(@lombok.NonNull Runnable remove) {
        if (remove == null) {
            throw new NullPointerException("remove is marked non-null but is null");
        }
        return this.remove == remove ? this : new IteratorFactory<E>(this.seed, this.hasNext, this.next, remove);
    }
}

