/*
 * Decompiled with CFR 0.152.
 */
package _test.io.text;

import _test.io.CountingIOSupplier;
import _test.io.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Function;
import lombok.NonNull;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.text.TextFormatter;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssertAlternative;

public final class TextFormatterAssertions {
    public static <T> void assertTextFormatterCompliance(@NonNull Path temp, @NonNull TextFormatter<T> p, @NonNull T value, @NonNull Function<Charset, String> expected, @NonNull Collection<Charset> encodings) throws IOException {
        if (temp == null) {
            throw new NullPointerException("temp is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        if (encodings == null) {
            throw new NullPointerException("encodings is marked non-null but is null");
        }
        Util.checkDefaultProvider(temp);
        TextFormatterAssertions.testFormatToString(p, value, expected.apply(StandardCharsets.UTF_8));
        TextFormatterAssertions.testFormatChars(p, value, expected.apply(StandardCharsets.UTF_8));
        TextFormatterAssertions.testFormatFileCharset(p, value, expected, encodings, temp);
        TextFormatterAssertions.testFormatPathCharset(p, value, expected, encodings, temp);
        TextFormatterAssertions.testFormatWriterFromSupplier(p, value, expected.apply(StandardCharsets.UTF_8));
        TextFormatterAssertions.testFormatStreamFromSupplierCharset(p, value, expected, encodings);
        TextFormatterAssertions.testFormatWriter(p, value, expected.apply(StandardCharsets.UTF_8));
        TextFormatterAssertions.testFormatStreamCharset(p, value, expected, encodings);
    }

    private static <T> void testFormatToString(TextFormatter<T> p, T value, String expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatToString(null)).withMessageContaining("value");
        Assertions.assertThat((String)p.formatToString(value)).isEqualTo(expected);
    }

    private static <T> void testFormatChars(TextFormatter<T> p, T value, String expected) throws IOException {
        StringBuilder nonNullTarget = new StringBuilder();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatChars(null, (Appendable)nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((StringBuilder)nonNullTarget).isEmpty();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatChars(value, null)).withMessageContaining("target");
        Assertions.assertThat((StringBuilder)nonNullTarget).isEmpty();
        StringBuilder appendable = new StringBuilder();
        p.formatChars(value, (Appendable)appendable);
        Assertions.assertThat((String)appendable.toString()).isEqualTo(expected);
    }

    private static <T> void testFormatFileCharset(TextFormatter<T> p, T value, Function<Charset, String> expected, Collection<Charset> encodings, Path temp) throws IOException {
        File nonNullTarget = Util.newFile(temp).toFile();
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(null, nonNullTarget, nonNullEncoding)).withMessageContaining("value");
        Assertions.assertThat((File)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(value, null, nonNullEncoding)).withMessageContaining("target");
        Assertions.assertThat((File)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(value, nonNullTarget, null)).withMessageContaining("encoding");
        Assertions.assertThat((File)nonNullTarget).doesNotExist();
        File dir = Util.newDir(temp).toFile();
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatFile(value, dir, StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        File target = Util.newFile(temp).toFile();
        for (Charset encoding : encodings) {
            p.formatFile(value, target, encoding);
            Assertions.assertThat((File)target).exists().isFile().usingCharset(encoding).hasContent(expected.apply(encoding));
            Util.deleteFile(target);
        }
    }

    private static <T> void testFormatPathCharset(TextFormatter<T> p, T value, Function<Charset, String> expected, Collection<Charset> encodings, Path temp) throws IOException {
        Path nonNullTarget = Util.newFile(temp);
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(null, nonNullTarget, nonNullEncoding)).withMessageContaining("value");
        Assertions.assertThat((Path)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(value, null, nonNullEncoding)).withMessageContaining("target");
        Assertions.assertThat((Path)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(value, nonNullTarget, null)).withMessageContaining("encoding");
        Assertions.assertThat((Path)nonNullTarget).doesNotExist();
        Path dir = Util.newDir(temp);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatPath(value, dir, StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        for (Charset encoding : encodings) {
            Path target = Util.newFile(temp);
            p.formatPath(value, target, encoding);
            Assertions.assertThat((Path)target).exists().isReadable().usingCharset(encoding).hasContent(expected.apply(encoding));
            Files.delete(target);
        }
    }

    private static <T> void testFormatWriterFromSupplier(TextFormatter<T> p, T value, String expected) throws IOException {
        CountingIOSupplier nonNullTarget = new CountingIOSupplier(StringWriter::new);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter(null, (IOSupplier)nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter(value, (IOSupplier)null)).withMessageContaining("target");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        StringWriter writer = new StringWriter();
        p.formatWriter(value, () -> writer);
        Assertions.assertThat((String)writer.toString()).isEqualTo(expected);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatWriter(value, IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing Writer");
        Assertions.assertThatIOException().isThrownBy(() -> p.formatWriter(value, Util.failingSupplier(() -> new TextFormatterTestError()))).isInstanceOf(TextFormatterTestError.class);
    }

    private static <T> void testFormatStreamFromSupplierCharset(TextFormatter<T> p, T value, Function<Charset, String> expected, Collection<Charset> encodings) throws IOException {
        CountingIOSupplier nonNullTarget = new CountingIOSupplier(ByteArrayOutputStream::new);
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, (IOSupplier)nonNullTarget, nonNullEncoding)).withMessageContaining("value");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (IOSupplier)null, nonNullEncoding)).withMessageContaining("target");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (IOSupplier)nonNullTarget, null)).withMessageContaining("encoding");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatStream(value, IOSupplier.of(null), StandardCharsets.UTF_8)).isInstanceOf(IOException.class)).withMessageContaining("Missing OutputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.formatStream(value, Util.failingSupplier(() -> new TextFormatterTestError()), StandardCharsets.UTF_8)).isInstanceOf(TextFormatterTestError.class);
        for (Charset encoding : encodings) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            p.formatStream(value, () -> stream, encoding);
            Assertions.assertThat((String)stream.toString(encoding.name())).isEqualTo(expected.apply(encoding));
        }
    }

    private static <T> void testFormatWriter(TextFormatter<T> p, T value, String expected) throws IOException {
        StringWriter nonNullTarget = new StringWriter();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter(null, (Writer)nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((String)nonNullTarget.toString()).isEmpty();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter(value, (Writer)null)).withMessageContaining("resource");
        Assertions.assertThat((String)nonNullTarget.toString()).isEmpty();
        StringWriter resource = new StringWriter();
        p.formatWriter(value, (Writer)resource);
        Assertions.assertThat((String)resource.toString()).isEqualTo(expected);
    }

    private static <T> void testFormatStreamCharset(TextFormatter<T> p, T value, Function<Charset, String> expected, Collection<Charset> encodings) throws IOException {
        ByteArrayOutputStream nonNullResource = new ByteArrayOutputStream();
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, (OutputStream)nonNullResource, nonNullEncoding)).withMessageContaining("value");
        Assertions.assertThat((byte[])nonNullResource.toByteArray()).hasSize(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (OutputStream)null, nonNullEncoding)).withMessageContaining("resource");
        Assertions.assertThat((byte[])nonNullResource.toByteArray()).hasSize(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (OutputStream)nonNullResource, null)).withMessageContaining("encoding");
        Assertions.assertThat((byte[])nonNullResource.toByteArray()).hasSize(0);
        for (Charset encoding : encodings) {
            ByteArrayOutputStream resource = new ByteArrayOutputStream();
            p.formatStream(value, (OutputStream)resource, encoding);
            Assertions.assertThat((String)resource.toString(encoding.name())).isEqualTo(expected.apply(encoding));
        }
    }

    private static final class TextFormatterTestError
    extends IOException {
        private TextFormatterTestError() {
        }
    }
}

