/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io;

import internal.io.UncloseableInputStream;
import internal.io.UncloseableOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.function.IOConsumer;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IORunnable;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Resource {
    @NonNull
    public static Optional<File> getFile(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path is marked non-null but is null");
        }
        return path.getFileSystem() == FileSystems.getDefault() ? Optional.of(new File(path.toString())) : Optional.empty();
    }

    @Deprecated
    @NonNull
    public static Optional<InputStream> getResourceAsStream(@NonNull Class<?> anchor, @NonNull String name) {
        if (anchor == null) {
            throw new NullPointerException("anchor is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return Optional.ofNullable(anchor.getResourceAsStream(name));
    }

    @NonNull
    public static InputStream newInputStream(@NonNull Class<?> anchor, @NonNull String name) throws IOException {
        if (anchor == null) {
            throw new NullPointerException("anchor is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        InputStream result = anchor.getResourceAsStream(name);
        if (result == null) {
            throw new IOException("Missing resource '" + name + "' of '" + anchor.getName() + "'");
        }
        return result;
    }

    public static void ensureClosed(@NonNull Throwable exception, @Nullable Closeable closeable) {
        if (exception == null) {
            throw new NullPointerException("exception is marked non-null but is null");
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException suppressed) {
                try {
                    exception.addSuppressed(suppressed);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public static void closeBoth(@Nullable Closeable first, @Nullable Closeable second) throws IOException {
        if (first != null) {
            try {
                first.close();
            }
            catch (IOException ex) {
                Resource.ensureClosed(ex, second);
                throw ex;
            }
        }
        if (second != null) {
            second.close();
        }
    }

    public static void process(@NonNull URI uri, @NonNull IOConsumer<? super Path> action) throws IOException {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        try {
            action.acceptWithIO(Paths.get(uri));
        }
        catch (FileSystemNotFoundException ex) {
            try (FileSystem fs = FileSystems.newFileSystem(uri, Collections.emptyMap());){
                action.acceptWithIO(fs.provider().getPath(uri));
            }
        }
    }

    @NonNull
    public static InputStream uncloseableInputStream(@NonNull InputStream delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        return new UncloseableInputStream(delegate);
    }

    @NonNull
    public static OutputStream uncloseableOutputStream(@NonNull OutputStream delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate is marked non-null but is null");
        }
        return new UncloseableOutputStream(delegate);
    }

    @Generated
    private Resource() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class FunctionalLoader<K>
    implements Loader<K> {
        @NonNull
        private final IOFunction<? super K, ? extends InputStream> loader;
        @NonNull
        private final Closeable closer;
        private boolean closed = false;

        @Override
        @NonNull
        public InputStream load(@NonNull K key) throws IOException {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            if (this.closed) {
                throw new IllegalStateException("Closed");
            }
            InputStream result = this.loader.applyWithIO(key);
            if (result == null) {
                throw new IOException("Null stream");
            }
            return result;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.closer.close();
        }

        @Generated
        public FunctionalLoader(@NonNull IOFunction<? super K, ? extends InputStream> loader, @NonNull Closeable closer) {
            if (loader == null) {
                throw new NullPointerException("loader is marked non-null but is null");
            }
            if (closer == null) {
                throw new NullPointerException("closer is marked non-null but is null");
            }
            this.loader = loader;
            this.closer = closer;
        }
    }

    public static interface Storer<K>
    extends Closeable {
        public void store(@NonNull K var1, @NonNull OutputStream var2) throws IOException, IllegalStateException;
    }

    public static interface Loader<K>
    extends Closeable {
        @NonNull
        public InputStream load(@NonNull K var1) throws IOException, IllegalStateException;

        @NonNull
        public static <K> Loader<K> of(@NonNull IOFunction<? super K, ? extends InputStream> loader) {
            if (loader == null) {
                throw new NullPointerException("loader is marked non-null but is null");
            }
            return Loader.of(loader, IORunnable.noOp().asCloseable());
        }

        @NonNull
        public static <K> Loader<K> of(@NonNull IOFunction<? super K, ? extends InputStream> loader, @NonNull Closeable closer) {
            if (loader == null) {
                throw new NullPointerException("loader is marked non-null but is null");
            }
            if (closer == null) {
                throw new NullPointerException("closer is marked non-null but is null");
            }
            return new FunctionalLoader<K>(loader, closer);
        }
    }
}

