/*
 * Decompiled with CFR 0.152.
 */
package _test.io.text;

import _test.io.ByteArrayOutputStream2;
import _test.io.CountingIOSupplier;
import _test.io.Util;
import _test.io.text.StringWriter2;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Function;
import lombok.NonNull;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.text.TextFormatter;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssertAlternative;

public final class TextFormatterAssertions {
    public static <T> void assertTextFormatterCompliance(@NonNull Path temp, @NonNull TextFormatter<T> p, @NonNull T value, @NonNull Function<Charset, String> expected, @NonNull Collection<Charset> encodings) throws IOException {
        if (temp == null) {
            throw new NullPointerException("temp is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        if (encodings == null) {
            throw new NullPointerException("encodings is marked non-null but is null");
        }
        Util.checkDefaultProvider(temp);
        TextFormatterAssertions.testFormatToString(p, value, expected.apply(StandardCharsets.UTF_8));
        TextFormatterAssertions.testFormatChars(p, value, expected.apply(StandardCharsets.UTF_8));
        TextFormatterAssertions.testFormatFile(p, value, expected, encodings, temp);
        TextFormatterAssertions.testFormatPath(p, value, expected, encodings, temp);
        TextFormatterAssertions.testFormatWriterFromSupplier(p, value, expected.apply(StandardCharsets.UTF_8));
        TextFormatterAssertions.testFormatWriter(p, value, expected.apply(StandardCharsets.UTF_8));
        TextFormatterAssertions.testFormatStreamFromSupplier(p, value, expected, encodings);
        TextFormatterAssertions.testFormatStream(p, value, expected, encodings);
    }

    private static <T> void testFormatToString(TextFormatter<T> p, T value, String expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatToString(null)).withMessageContaining("value");
        Assertions.assertThat((String)p.formatToString(value)).isEqualTo(expected);
    }

    private static <T> void testFormatChars(TextFormatter<T> p, T value, String expected) throws IOException {
        StringBuilder nonNullTarget = new StringBuilder();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatChars(null, (Appendable)nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((StringBuilder)nonNullTarget).isEmpty();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatChars(value, null)).withMessageContaining("target");
        Assertions.assertThat((StringBuilder)nonNullTarget).isEmpty();
        StringBuilder appendable = new StringBuilder();
        p.formatChars(value, (Appendable)appendable);
        Assertions.assertThat((String)appendable.toString()).isEqualTo(expected);
    }

    private static <T> void testFormatFile(TextFormatter<T> p, T value, Function<Charset, String> expected, Collection<Charset> encodings, Path temp) throws IOException {
        File nonNullTarget = Util.newFile(temp).toFile();
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(null, nonNullTarget, nonNullEncoding)).withMessageContaining("value");
        Assertions.assertThat((File)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(value, null, nonNullEncoding)).withMessageContaining("target");
        Assertions.assertThat((File)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(value, nonNullTarget, null)).withMessageContaining("encoding");
        Assertions.assertThat((File)nonNullTarget).doesNotExist();
        File dir = Util.newDir(temp).toFile();
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatFile(value, dir, StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        File target = Util.newFile(temp).toFile();
        for (Charset encoding : encodings) {
            p.formatFile(value, target, encoding);
            Assertions.assertThat((File)target).exists().isFile().usingCharset(encoding).hasContent(expected.apply(encoding));
            Util.deleteFile(target);
        }
    }

    private static <T> void testFormatPath(TextFormatter<T> p, T value, Function<Charset, String> expected, Collection<Charset> encodings, Path temp) throws IOException {
        Path nonNullTarget = Util.newFile(temp);
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(null, nonNullTarget, nonNullEncoding)).withMessageContaining("value");
        Assertions.assertThat((Path)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(value, null, nonNullEncoding)).withMessageContaining("target");
        Assertions.assertThat((Path)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(value, nonNullTarget, null)).withMessageContaining("encoding");
        Assertions.assertThat((Path)nonNullTarget).doesNotExist();
        Path dir = Util.newDir(temp);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatPath(value, dir, StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        for (Charset encoding : encodings) {
            Path target = Util.newFile(temp);
            p.formatPath(value, target, encoding);
            Assertions.assertThat((Path)target).exists().isReadable().usingCharset(encoding).hasContent(expected.apply(encoding));
            Files.delete(target);
        }
    }

    private static <T> void testFormatWriterFromSupplier(TextFormatter<T> p, T value, String expected) {
        CountingIOSupplier nonNullTarget = new CountingIOSupplier(StringWriter::new);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter(null, (IOSupplier)nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter(value, (IOSupplier)null)).withMessageContaining("target");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatWriter(value, IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing Writer");
        Assertions.assertThatIOException().isThrownBy(() -> p.formatWriter(value, Util.failingSupplier(() -> new TextFormatterTestError()))).isInstanceOf(TextFormatterTestError.class);
        try (StringWriter2 resource = new StringWriter2();){
            Assertions.assertThatCode(() -> p.formatWriter(value, () -> resource)).doesNotThrowAnyException();
            ((AbstractStringAssert)Assertions.assertThat((String)resource.toString()).describedAs("Formatter must write to resource if value is not null", new Object[0])).isEqualTo(expected);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Formatter must close supplied resource", new Object[0])).isEqualTo(1);
        }
    }

    private static <T> void testFormatStreamFromSupplier(TextFormatter<T> p, T value, Function<Charset, String> expected, Collection<Charset> encodings) {
        CountingIOSupplier nonNullTarget = new CountingIOSupplier(ByteArrayOutputStream::new);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, (IOSupplier)nonNullTarget, StandardCharsets.UTF_8)).withMessageContaining("value");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (IOSupplier)null, StandardCharsets.UTF_8)).withMessageContaining("target");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (IOSupplier)nonNullTarget, null)).withMessageContaining("encoding");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatStream(value, IOSupplier.of(null), StandardCharsets.UTF_8)).isInstanceOf(IOException.class)).withMessageContaining("Missing OutputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.formatStream(value, Util.failingSupplier(() -> new TextFormatterTestError()), StandardCharsets.UTF_8)).isInstanceOf(TextFormatterTestError.class);
        for (Charset encoding : encodings) {
            try (ByteArrayOutputStream2 resource = new ByteArrayOutputStream2();){
                Assertions.assertThatCode(() -> p.formatStream(value, () -> resource, encoding)).doesNotThrowAnyException();
                ((AbstractStringAssert)Assertions.assertThat((String)resource.toString(encoding)).describedAs("Formatter must write to resource if value is not null", new Object[0])).isEqualTo(expected.apply(encoding));
                ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Formatter must close supplied resource", new Object[0])).isEqualTo(1);
            }
        }
    }

    private static <T> void testFormatWriter(TextFormatter<T> p, T value, String expected) {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter(value, (Writer)null)).withMessageContaining("resource");
        try (StringWriter2 resource = new StringWriter2();){
            Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatWriter(null, (Writer)resource)).withMessageContaining("value");
            ((AbstractStringAssert)Assertions.assertThat((String)resource.toString()).describedAs("Formatter may not write to resource if value is null", new Object[0])).isEmpty();
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Formatter may not close resource", new Object[0])).isEqualTo(0);
        }
        resource = new StringWriter2();
        try {
            Assertions.assertThatCode(() -> p.formatWriter(value, (Writer)resource)).doesNotThrowAnyException();
            ((AbstractStringAssert)Assertions.assertThat((String)resource.toString()).describedAs("Formatter must write to resource if value is not null", new Object[0])).isEqualTo(expected);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Formatter may not close resource", new Object[0])).isEqualTo(0);
        }
        finally {
            resource.close();
        }
    }

    private static <T> void testFormatStream(TextFormatter<T> p, T value, Function<Charset, String> expected, Collection<Charset> encodings) {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (OutputStream)null, StandardCharsets.UTF_8)).withMessageContaining("resource");
        try (Object resource = new ByteArrayOutputStream2();){
            Assertions.assertThatNullPointerException().isThrownBy(() -> TextFormatterAssertions.lambda$testFormatStream$30(p, (ByteArrayOutputStream2)resource)).withMessageContaining("value");
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])((ByteArrayOutputStream)resource).toByteArray()).describedAs("Formatter may not write to resource if value is null", new Object[0])).isEmpty();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((ByteArrayOutputStream2)resource).getCloseCount()).describedAs("Formatter may not close resource", new Object[0])).isEqualTo(0);
        }
        for (Charset encoding : encodings) {
            try (ByteArrayOutputStream2 resource = new ByteArrayOutputStream2();){
                Assertions.assertThatCode(() -> p.formatStream(value, (OutputStream)resource, encoding)).doesNotThrowAnyException();
                ((AbstractStringAssert)Assertions.assertThat((String)resource.toString(encoding)).describedAs("Formatter must write to resource if value is not null", new Object[0])).isEqualTo(expected.apply(encoding));
                ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Formatter may not close resource", new Object[0])).isEqualTo(0);
            }
        }
        resource = new ByteArrayOutputStream2();
        try {
            Assertions.assertThatNullPointerException().isThrownBy(() -> TextFormatterAssertions.lambda$testFormatStream$32(p, value, (ByteArrayOutputStream2)resource)).withMessageContaining("encoding");
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])((ByteArrayOutputStream)resource).toByteArray()).describedAs("Formatter may not write to resource if encoding is null", new Object[0])).isEmpty();
            ((AbstractIntegerAssert)Assertions.assertThat((int)((ByteArrayOutputStream2)resource).getCloseCount()).describedAs("Formatter may not close resource", new Object[0])).isEqualTo(0);
        }
        finally {
            ((ByteArrayOutputStream2)resource).close();
        }
    }

    private static /* synthetic */ void lambda$testFormatStream$32(TextFormatter p, Object value, ByteArrayOutputStream2 resource) throws Throwable {
        p.formatStream(value, (OutputStream)resource, null);
    }

    private static /* synthetic */ void lambda$testFormatStream$30(TextFormatter p, ByteArrayOutputStream2 resource) throws Throwable {
        p.formatStream(null, (OutputStream)resource, StandardCharsets.UTF_8);
    }

    private static final class TextFormatterTestError
    extends IOException {
        private TextFormatterTestError() {
        }
    }
}

