/*
 * Decompiled with CFR 0.152.
 */
package _test.io;

import _test.io.ByteArrayOutputStream2;
import _test.io.CountingIOSupplier;
import _test.io.Util;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import lombok.NonNull;
import nbbrd.io.FileFormatter;
import nbbrd.io.function.IOSupplier;
import org.assertj.core.api.AbstractByteArrayAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssertAlternative;

public final class FileFormatterAssertions {
    public static <T> void assertFileFormatterCompliance(@NonNull Path temp, @NonNull FileFormatter<T> p, @NonNull T value, @NonNull byte[] expected) throws IOException {
        if (temp == null) {
            throw new NullPointerException("temp is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        Util.checkDefaultProvider(temp);
        FileFormatterAssertions.testFormatFile(p, value, expected, temp);
        FileFormatterAssertions.testFormatPath(p, value, expected, temp);
        FileFormatterAssertions.testFormatStreamFromSupplier(p, value, expected);
        FileFormatterAssertions.testFormatStream(p, value, expected);
    }

    private static <T> void testFormatFile(FileFormatter<T> p, T value, byte[] expected, Path temp) throws IOException {
        File nonNullTarget = Util.newFile(temp).toFile();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(null, nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((File)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatFile(value, null)).withMessageContaining("target");
        Assertions.assertThat((File)nonNullTarget).doesNotExist();
        File dir = Util.newDir(temp).toFile();
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatFile(value, dir)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        File target = Util.newFile(temp).toFile();
        p.formatFile(value, target);
        Assertions.assertThat((File)target).exists().isFile().hasBinaryContent(expected);
    }

    private static <T> void testFormatPath(FileFormatter<T> p, T value, byte[] expected, Path temp) throws IOException {
        Path nonNullTarget = Util.newFile(temp);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(null, nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((Path)nonNullTarget).doesNotExist();
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatPath(value, null)).withMessageContaining("target");
        Assertions.assertThat((Path)nonNullTarget).doesNotExist();
        Path dir = Util.newDir(temp);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatPath(value, dir)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        Path target = Util.newFile(temp);
        p.formatPath(value, target);
        Assertions.assertThat((Path)target).exists().isReadable().hasBinaryContent(expected);
    }

    private static <T> void testFormatStreamFromSupplier(FileFormatter<T> p, T value, byte[] expected) {
        CountingIOSupplier nonNullTarget = new CountingIOSupplier(ByteArrayOutputStream::new);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, (IOSupplier)nonNullTarget)).withMessageContaining("value");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (IOSupplier)null)).withMessageContaining("target");
        Assertions.assertThat((int)nonNullTarget.getCount()).isEqualTo(0);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.formatStream(value, IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing OutputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.formatStream(value, Util.failingSupplier(() -> new FileFormatterTestError()))).isInstanceOf(FileFormatterTestError.class);
        try (ByteArrayOutputStream2 resource = new ByteArrayOutputStream2();){
            Assertions.assertThatCode(() -> p.formatStream(value, () -> resource)).doesNotThrowAnyException();
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])resource.toByteArray()).describedAs("Formatter must write to resource if value is not null", new Object[0])).isEqualTo((Object)expected);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Formatter must close supplied resource", new Object[0])).isEqualTo(1);
        }
    }

    private static <T> void testFormatStream(FileFormatter<T> p, T value, byte[] expected) {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(value, (OutputStream)null)).withMessageContaining("resource");
        try (ByteArrayOutputStream2 resource = new ByteArrayOutputStream2();){
            Assertions.assertThatNullPointerException().isThrownBy(() -> p.formatStream(null, (OutputStream)resource)).withMessageContaining("value");
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])resource.toByteArray()).describedAs("Formatter may not write to resource if value is null", new Object[0])).isEmpty();
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Formatter may not close resource", new Object[0])).isEqualTo(0);
        }
        resource = new ByteArrayOutputStream2();
        try {
            Assertions.assertThatCode(() -> p.formatStream(value, (OutputStream)resource)).doesNotThrowAnyException();
            ((AbstractByteArrayAssert)Assertions.assertThat((byte[])resource.toByteArray()).describedAs("Formatter must write to resource if value is not null", new Object[0])).isEqualTo((Object)expected);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Formatter may not close resource", new Object[0])).isEqualTo(0);
        }
        finally {
            resource.close();
        }
    }

    private static final class FileFormatterTestError
    extends IOException {
        private FileFormatterTestError() {
        }
    }
}

