/*
 * Decompiled with CFR 0.152.
 */
package _test.io;

import internal.io.InternalResource;
import internal.io.text.InternalTextResource;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import lombok.Generated;
import nbbrd.io.Resource;
import nbbrd.io.text.TextResource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ResourceId {
    @lombok.NonNull
    private final Class<?> anchor;
    @lombok.NonNull
    private final String name;

    public InputStream open() throws IOException {
        return Resource.newInputStream(this.anchor, (String)this.name);
    }

    public Path copyTo(Path temp) throws IOException {
        Path result = Files.createTempFile(temp, "x", "y", new FileAttribute[0]);
        try (InputStream stream = this.open();){
            Files.copy(stream, result, StandardCopyOption.REPLACE_EXISTING);
        }
        return result;
    }

    public byte[] toBytes() throws IOException {
        try (InputStream input = this.open();){
            byte[] byArray = InternalResource.readAllBytes((InputStream)input);
            return byArray;
        }
    }

    public BufferedReader open(Charset encoding) throws IOException {
        return TextResource.newBufferedReader(this.anchor, (String)this.name, (Charset)encoding);
    }

    public String copyToString(Charset encoding) throws IOException {
        try (BufferedReader reader = this.open(encoding);){
            String string = InternalTextResource.copyToString((Reader)reader);
            return string;
        }
    }

    public String copyByLineToString(Charset encoding, String separator) throws IOException {
        try (BufferedReader reader = this.open(encoding);){
            String string = InternalTextResource.copyByLineToString((Reader)reader, (String)separator);
            return string;
        }
    }

    @Generated
    public ResourceId(@lombok.NonNull Class<?> anchor, @lombok.NonNull String name) {
        if (anchor == null) {
            throw new NullPointerException("anchor is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.anchor = anchor;
        this.name = name;
    }

    @lombok.NonNull
    @Generated
    public Class<?> getAnchor() {
        return this.anchor;
    }

    @lombok.NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceId)) {
            return false;
        }
        ResourceId other = (ResourceId)o;
        Class<?> this$anchor = this.getAnchor();
        Class<?> other$anchor = other.getAnchor();
        if (this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : $anchor.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "ResourceId(anchor=" + String.valueOf(this.getAnchor()) + ", name=" + this.getName() + ")";
    }
}

