/*
 * Decompiled with CFR 0.152.
 */
package _test.io;

import internal.io.InternalResource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import nbbrd.io.Resource;
import nbbrd.io.WrappedIOException;
import nbbrd.io.function.IORunnable;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.function.IOUnaryOperator;
import nbbrd.io.sys.SystemProperties;
import org.assertj.core.api.Condition;

public final class Util {
    public static final String INVALID_FILE_PATH = "*\"/\\<>:|?\u0000";

    public static boolean isJDK8() {
        return SystemProperties.DEFAULT.getJavaVersion().contains("1.8");
    }

    public static void deleteFile(File target) throws IOException {
        if (!target.delete()) {
            throw new IOException("Cannot delete " + String.valueOf(target));
        }
    }

    public static <X> IOSupplier<X> failingSupplier(Supplier<IOException> error) {
        return () -> {
            throw (IOException)error.get();
        };
    }

    public static Path newEmptyFile(Path temp) throws IOException {
        return Files.createTempFile(temp, "file", "empty", new FileAttribute[0]);
    }

    public static Path newFile(Path temp) throws IOException {
        Path result = Files.createTempFile(temp, "file", "missing", new FileAttribute[0]);
        Files.delete(result);
        return result;
    }

    public static Path newDir(Path temp) throws IOException {
        return Files.createTempDirectory(temp, "dir", new FileAttribute[0]);
    }

    public static InputStream emptyInputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    public static Path checkDefaultProvider(Path path) throws IllegalArgumentException {
        if (!Resource.getFile((Path)path).isPresent()) {
            throw new IllegalArgumentException("Path not in default provider: '" + String.valueOf(path) + "'");
        }
        return path;
    }

    public static FileTime lastAccessTime(Path file) throws IOException {
        return Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]).lastAccessTime();
    }

    public static byte[] encode(byte[] bytes, IOUnaryOperator<OutputStream> encoder) throws IOException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try (OutputStream output = (OutputStream)encoder.applyWithIO((Object)result);){
            output.write(bytes, 0, bytes.length);
        }
        return result.toByteArray();
    }

    public static byte[] decode(byte[] bytes, IOUnaryOperator<InputStream> encoder) throws IOException {
        try (InputStream input = (InputStream)encoder.applyWithIO((Object)new ByteArrayInputStream(bytes));){
            byte[] byArray = InternalResource.readAllBytes((InputStream)input);
            return byArray;
        }
    }

    public static Condition<Throwable> wrappedIOExceptionOfType(Class<?> type) {
        return new Condition(o -> o instanceof WrappedIOException && type.isInstance(o.getCause()), "", new Object[0]);
    }

    public static List<Throwable> running(int n, IORunnable runnable) {
        return IntStream.range(0, n).parallel().mapToObj(i -> {
            try {
                runnable.runWithIO();
            }
            catch (Throwable ex) {
                return ex;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

