/*
 * Decompiled with CFR 0.152.
 */
package _test.io.text;

import _test.io.ByteArrayInputStream2;
import _test.io.CountingIOSupplier;
import _test.io.CountingInputStream;
import _test.io.ResourceId;
import _test.io.Util;
import _test.io.text.StringReader2;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Function;
import lombok.NonNull;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.text.TextParser;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssertAlternative;

public final class TextParserAssertions {
    public static <T> void assertTextParserCompliance(@NonNull Path temp, @NonNull TextParser<T> p, @NonNull T value, @NonNull Function<Charset, ResourceId> expected, @NonNull Collection<Charset> encodings, boolean allowEmpty) throws IOException {
        if (temp == null) {
            throw new NullPointerException("temp is marked non-null but is null");
        }
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (expected == null) {
            throw new NullPointerException("expected is marked non-null but is null");
        }
        if (encodings == null) {
            throw new NullPointerException("encodings is marked non-null but is null");
        }
        Util.checkDefaultProvider(temp);
        TextParserAssertions.testParseChars(p, value, expected);
        TextParserAssertions.testParseFile(p, temp, value, expected, encodings, allowEmpty);
        TextParserAssertions.testParsePath(p, temp, value, expected, encodings, allowEmpty);
        TextParserAssertions.testParseResource(p, value, expected);
        TextParserAssertions.testParseReaderFromSupplier(p, value, expected);
        TextParserAssertions.testParseStreamFromSupplier(p, value, expected);
        TextParserAssertions.testParseReader(p, value, expected);
        TextParserAssertions.testParseStream(p, value, expected);
    }

    private static <T> void testParseChars(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseChars(null)).withMessageContaining("source");
        String chars = expected.apply(StandardCharsets.UTF_8).copyToString(StandardCharsets.UTF_8);
        Assertions.assertThat((Object)p.parseChars((CharSequence)chars)).isEqualTo(value);
    }

    private static <T> void testParseFile(TextParser<T> p, Path temp, T value, Function<Charset, ResourceId> expected, Collection<Charset> encodings, boolean allowEmpty) throws IOException {
        File nonNullSource = Util.newEmptyFile(temp).toFile();
        FileTime refTime = Util.lastAccessTime(nonNullSource.toPath());
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseFile(null, StandardCharsets.UTF_8)).withMessageContaining("source");
        Assertions.assertThat((Comparable)Util.lastAccessTime(nonNullSource.toPath())).isEqualTo((Object)refTime);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseFile(nonNullSource, null)).withMessageContaining("encoding");
        Assertions.assertThat((Comparable)Util.lastAccessTime(nonNullSource.toPath())).isEqualTo((Object)refTime);
        if (!allowEmpty) {
            File emptyFile = Util.newEmptyFile(temp).toFile();
            ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(emptyFile, StandardCharsets.UTF_8)).isInstanceOf(EOFException.class)).withMessageContaining(emptyFile.toString());
        }
        File missingFile = Util.newFile(temp).toFile();
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(missingFile, StandardCharsets.UTF_8)).isInstanceOf(NoSuchFileException.class)).withMessageContaining(missingFile.toString());
        File dir = Util.newDir(temp).toFile();
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseFile(dir, StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        for (Charset encoding : encodings) {
            File file = expected.apply(encoding).copyTo(temp).toFile();
            Assertions.assertThat((Object)p.parseFile(file, encoding)).isEqualTo(value);
        }
    }

    private static <T> void testParsePath(TextParser<T> p, Path temp, T value, Function<Charset, ResourceId> expected, Collection<Charset> encodings, boolean allowEmpty) throws IOException {
        Path nonNullSource = Util.newEmptyFile(temp);
        FileTime refTime = Util.lastAccessTime(nonNullSource);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parsePath(null, StandardCharsets.UTF_8)).withMessageContaining("source");
        Assertions.assertThat((Comparable)Util.lastAccessTime(nonNullSource)).isEqualTo((Object)refTime);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parsePath(nonNullSource, null)).withMessageContaining("encoding");
        Assertions.assertThat((Comparable)Util.lastAccessTime(nonNullSource)).isEqualTo((Object)refTime);
        if (!allowEmpty) {
            Path emptyFile = Util.newEmptyFile(temp);
            ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(emptyFile, StandardCharsets.UTF_8)).isInstanceOf(EOFException.class)).withMessageContaining(emptyFile.toString());
        }
        Path missingFile = Util.newFile(temp);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(missingFile, StandardCharsets.UTF_8)).isInstanceOf(NoSuchFileException.class)).withMessageContaining(missingFile.toString());
        Path dir = Util.newDir(temp);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parsePath(dir, StandardCharsets.UTF_8)).isInstanceOf(AccessDeniedException.class)).withMessageContaining(dir.toString());
        for (Charset encoding : encodings) {
            ResourceId id = expected.apply(encoding);
            Path target = id.copyTo(temp);
            Assertions.assertThat((Object)p.parsePath(target, encoding)).isEqualTo(value);
        }
    }

    private static <T> void testParseResource(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        Class<TextParserAssertions> nonNullType = TextParserAssertions.class;
        String nonNullName = "";
        Charset nonNullEncoding = StandardCharsets.UTF_8;
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(null, nonNullName, nonNullEncoding)).withMessageContaining("type");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(nonNullType, null, nonNullEncoding)).withMessageContaining("name");
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseResource(nonNullType, nonNullName, null)).withMessageContaining("encoding");
        String missingResource = UUID.randomUUID().toString();
        Assertions.assertThatIOException().isThrownBy(() -> p.parseResource(TextParserAssertions.class, missingResource, StandardCharsets.UTF_8)).withMessageContaining("Missing").withMessageContaining(missingResource).withMessageContaining(TextParserAssertions.class.getName());
        ResourceId resourceId = expected.apply(StandardCharsets.UTF_8);
        Assertions.assertThat((Object)p.parseResource(resourceId.getAnchor(), resourceId.getName(), StandardCharsets.UTF_8)).isEqualTo(value);
    }

    private static <T> void testParseReaderFromSupplier(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseReader((IOSupplier)null)).withMessageContaining("source");
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseReader(IOSupplier.of(null))).isInstanceOf(IOException.class)).withMessageContaining("Missing Reader");
        Assertions.assertThatIOException().isThrownBy(() -> p.parseReader(Util.failingSupplier(() -> new TextParserTestError()))).isInstanceOf(TextParserTestError.class);
        try (StringReader2 resource = new StringReader2(expected.apply(StandardCharsets.UTF_8).copyToString(StandardCharsets.UTF_8));){
            Assertions.assertThat((Object)p.parseReader(() -> resource)).isEqualTo(value);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.read()).describedAs("Parser must read from resource if value is not null", new Object[0])).isEqualTo(-1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Parser must close supplied resource", new Object[0])).isEqualTo(1);
        }
    }

    private static <T> void testParseStreamFromSupplier(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        CountingIOSupplier nonNullSource = new CountingIOSupplier(Util::emptyInputStream);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((IOSupplier)null, StandardCharsets.UTF_8)).withMessageContaining("source");
        Assertions.assertThat((int)nonNullSource.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((IOSupplier)nonNullSource, null)).withMessageContaining("encoding");
        Assertions.assertThat((int)nonNullSource.getCount()).isEqualTo(0);
        ((ThrowableAssertAlternative)Assertions.assertThatIOException().isThrownBy(() -> p.parseStream(IOSupplier.of(null), StandardCharsets.UTF_8)).isInstanceOf(IOException.class)).withMessageContaining("Missing InputStream");
        Assertions.assertThatIOException().isThrownBy(() -> p.parseStream(Util.failingSupplier(() -> new TextParserTestError()), StandardCharsets.UTF_8)).isInstanceOf(TextParserTestError.class);
        try (ByteArrayInputStream2 resource = new ByteArrayInputStream2(expected.apply(StandardCharsets.UTF_8).toBytes());){
            Assertions.assertThat((Object)p.parseStream(() -> resource, StandardCharsets.UTF_8)).isEqualTo(value);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.available()).describedAs("Parser must read from resource if value is not null", new Object[0])).isEqualTo(0);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Parser must close supplied resource", new Object[0])).isEqualTo(1);
        }
    }

    private static <T> void testParseReader(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseReader((Reader)null)).withMessageContaining("resource");
        try (StringReader2 resource = new StringReader2(expected.apply(StandardCharsets.UTF_8).copyToString(StandardCharsets.UTF_8));){
            Assertions.assertThat((Object)p.parseReader((Reader)resource)).isEqualTo(value);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.read()).describedAs("Parser must read from resource if value is not null", new Object[0])).isEqualTo(-1);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Parser may not close resource", new Object[0])).isEqualTo(0);
        }
    }

    private static <T> void testParseStream(TextParser<T> p, T value, Function<Charset, ResourceId> expected) throws IOException {
        CountingInputStream nonNullSource = new CountingInputStream(Util.emptyInputStream());
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((InputStream)null, StandardCharsets.UTF_8)).withMessageContaining("resource");
        Assertions.assertThat((int)nonNullSource.getCount()).isEqualTo(0);
        Assertions.assertThatNullPointerException().isThrownBy(() -> p.parseStream((InputStream)nonNullSource, null)).withMessageContaining("encoding");
        Assertions.assertThat((int)nonNullSource.getCount()).isEqualTo(0);
        try (ByteArrayInputStream2 resource = new ByteArrayInputStream2(expected.apply(StandardCharsets.UTF_8).toBytes());){
            Assertions.assertThat((Object)p.parseStream((InputStream)resource, StandardCharsets.UTF_8)).isEqualTo(value);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.available()).describedAs("Parser must read from resource if value is not null", new Object[0])).isEqualTo(0);
            ((AbstractIntegerAssert)Assertions.assertThat((int)resource.getCloseCount()).describedAs("Parser may not close resource", new Object[0])).isEqualTo(0);
        }
    }

    private static final class TextParserTestError
    extends IOException {
        private TextParserTestError() {
        }
    }
}

