/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io;

import internal.io.ComposeFileFormatter;
import internal.io.EncodingFileFormatter;
import internal.io.FunctionalFileFormatter;
import internal.io.InternalResource;
import internal.io.LockingFileFormatter;
import internal.io.text.LegacyFiles;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.zip.GZIPOutputStream;
import lombok.NonNull;
import nbbrd.io.Resource;
import nbbrd.io.function.IOBiConsumer;
import nbbrd.io.function.IOFunction;
import nbbrd.io.function.IOSupplier;

public interface FileFormatter<T> {
    default public void formatFile(@NonNull T value, @NonNull File target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        try (BufferedOutputStream bufferedResource = new BufferedOutputStream(LegacyFiles.newOutputStream(target));){
            this.formatStream(value, bufferedResource);
        }
    }

    default public void formatPath(@NonNull T value, @NonNull Path target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        Optional<File> file = Resource.getFile(target);
        if (file.isPresent()) {
            this.formatFile(value, file.get());
        } else {
            this.formatStream(value, () -> Files.newOutputStream(target, new OpenOption[0]));
        }
    }

    default public void formatStream(@NonNull T value, @NonNull IOSupplier<? extends OutputStream> target) throws IOException {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (target == null) {
            throw new NullPointerException("target is marked non-null but is null");
        }
        try (OutputStream resource = InternalResource.openOutputStream(target);){
            this.formatStream(value, resource);
        }
    }

    public void formatStream(@NonNull T var1, @NonNull OutputStream var2) throws IOException;

    @NonNull
    default public <V> FileFormatter<V> compose(@NonNull IOFunction<? super V, ? extends T> before) {
        if (before == null) {
            throw new NullPointerException("before is marked non-null but is null");
        }
        return new ComposeFileFormatter<V, T>(this, before);
    }

    @NonNull
    public static <T> FileFormatter<T> onFormattingStream(@NonNull IOBiConsumer<? super T, ? super OutputStream> function) {
        if (function == null) {
            throw new NullPointerException("function is marked non-null but is null");
        }
        return new FunctionalFileFormatter<T>(function);
    }

    @NonNull
    public static <T> FileFormatter<T> onFormattingGzip(@NonNull FileFormatter<T> formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return new EncodingFileFormatter<T>(formatter, GZIPOutputStream::new);
    }

    @NonNull
    public static <T> FileFormatter<T> onFormattingLock(@NonNull FileFormatter<T> formatter) {
        if (formatter == null) {
            throw new NullPointerException("formatter is marked non-null but is null");
        }
        return new LockingFileFormatter<T>(formatter);
    }
}

