/*
 * Decompiled with CFR 0.152.
 */
package _test.io;

import java.io.IOException;
import java.util.NoSuchElementException;
import lombok.Generated;
import nbbrd.io.IOIterator;
import nbbrd.io.function.IOPredicate;
import nbbrd.io.function.IORunnable;
import nbbrd.io.function.IOSupplier;
import nbbrd.io.function.IOUnaryOperator;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IOIteratorFactory<E>
implements IOSupplier<IOIterator<E>> {
    @lombok.NonNull
    private final IOSupplier<E> seed;
    @lombok.NonNull
    private final IOPredicate<? super E> hasNext;
    @lombok.NonNull
    private final IOUnaryOperator<E> next;
    @lombok.NonNull
    private final IORunnable remove;

    public IOIterator<E> getWithIO() throws IOException {
        return new IOIterator<E>(){
            final IOIterator<E> delegate;
            {
                this.delegate = IOIterator.iterate((IOSupplier)IOIteratorFactory.this.seed, (IOPredicate)IOIteratorFactory.this.hasNext, (IOUnaryOperator)IOIteratorFactory.this.next);
            }

            public boolean hasNextWithIO() throws IOException {
                return this.delegate.hasNextWithIO();
            }

            public E nextWithIO() throws IOException, NoSuchElementException {
                return this.delegate.nextWithIO();
            }

            public void removeWithIO() throws IOException {
                IOIteratorFactory.this.remove.runWithIO();
            }
        };
    }

    public static void drainForEach(IOIterator<?> iter) throws IOException {
        iter.forEachRemainingWithIO(o -> iter.removeWithIO());
    }

    public static void drainNext(IOIterator<?> iter) throws IOException {
        while (iter.hasNextWithIO()) {
            iter.nextWithIO();
            iter.removeWithIO();
        }
    }

    public static void browseNext(IOIterator<?> iterator) throws IOException {
        while (iterator.hasNextWithIO()) {
            iterator.nextWithIO();
        }
    }

    @Generated
    public IOIteratorFactory(@lombok.NonNull IOSupplier<E> seed, @lombok.NonNull IOPredicate<? super E> hasNext, @lombok.NonNull IOUnaryOperator<E> next, @lombok.NonNull IORunnable remove) {
        if (seed == null) {
            throw new NullPointerException("seed is marked non-null but is null");
        }
        if (hasNext == null) {
            throw new NullPointerException("hasNext is marked non-null but is null");
        }
        if (next == null) {
            throw new NullPointerException("next is marked non-null but is null");
        }
        if (remove == null) {
            throw new NullPointerException("remove is marked non-null but is null");
        }
        this.seed = seed;
        this.hasNext = hasNext;
        this.next = next;
        this.remove = remove;
    }

    @lombok.NonNull
    @Generated
    public IOSupplier<E> getSeed() {
        return this.seed;
    }

    @lombok.NonNull
    @Generated
    public IOPredicate<? super E> getHasNext() {
        return this.hasNext;
    }

    @lombok.NonNull
    @Generated
    public IOUnaryOperator<E> getNext() {
        return this.next;
    }

    @lombok.NonNull
    @Generated
    public IORunnable getRemove() {
        return this.remove;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IOIteratorFactory)) {
            return false;
        }
        IOIteratorFactory other = (IOIteratorFactory)o;
        IOSupplier<E> this$seed = this.getSeed();
        IOSupplier<E> other$seed = other.getSeed();
        if (this$seed == null ? other$seed != null : !this$seed.equals(other$seed)) {
            return false;
        }
        IOPredicate<E> this$hasNext = this.getHasNext();
        IOPredicate<E> other$hasNext = other.getHasNext();
        if (this$hasNext == null ? other$hasNext != null : !this$hasNext.equals(other$hasNext)) {
            return false;
        }
        IOUnaryOperator<E> this$next = this.getNext();
        IOUnaryOperator<E> other$next = other.getNext();
        if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
            return false;
        }
        IORunnable this$remove = this.getRemove();
        IORunnable other$remove = other.getRemove();
        return !(this$remove == null ? other$remove != null : !this$remove.equals(other$remove));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IOSupplier<E> $seed = this.getSeed();
        result = result * 59 + ($seed == null ? 43 : $seed.hashCode());
        IOPredicate<E> $hasNext = this.getHasNext();
        result = result * 59 + ($hasNext == null ? 43 : $hasNext.hashCode());
        IOUnaryOperator<E> $next = this.getNext();
        result = result * 59 + ($next == null ? 43 : $next.hashCode());
        IORunnable $remove = this.getRemove();
        result = result * 59 + ($remove == null ? 43 : $remove.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "IOIteratorFactory(seed=" + String.valueOf(this.getSeed()) + ", hasNext=" + String.valueOf(this.getHasNext()) + ", next=" + String.valueOf(this.getNext()) + ", remove=" + String.valueOf(this.getRemove()) + ")";
    }

    @Generated
    public @NonNull IOIteratorFactory<E> withSeed(@lombok.NonNull IOSupplier<E> seed) {
        if (seed == null) {
            throw new NullPointerException("seed is marked non-null but is null");
        }
        return this.seed == seed ? this : new IOIteratorFactory<E>(seed, this.hasNext, this.next, this.remove);
    }

    @Generated
    public @NonNull IOIteratorFactory<E> withHasNext(@lombok.NonNull IOPredicate<? super E> hasNext) {
        if (hasNext == null) {
            throw new NullPointerException("hasNext is marked non-null but is null");
        }
        return this.hasNext == hasNext ? this : new IOIteratorFactory<E>(this.seed, hasNext, this.next, this.remove);
    }

    @Generated
    public @NonNull IOIteratorFactory<E> withNext(@lombok.NonNull IOUnaryOperator<E> next) {
        if (next == null) {
            throw new NullPointerException("next is marked non-null but is null");
        }
        return this.next == next ? this : new IOIteratorFactory<E>(this.seed, this.hasNext, next, this.remove);
    }

    @Generated
    public @NonNull IOIteratorFactory<E> withRemove(@lombok.NonNull IORunnable remove) {
        if (remove == null) {
            throw new NullPointerException("remove is marked non-null but is null");
        }
        return this.remove == remove ? this : new IOIteratorFactory<E>(this.seed, this.hasNext, this.next, remove);
    }
}

