/*
 * Decompiled with CFR 0.152.
 */
package nbbrd.io.net;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.Parser;
import org.jspecify.annotations.Nullable;

public final class MediaType {
    static final String WILDCARD = "*";
    static final String CHARSET_PARAMETER = "charset";
    public static final MediaType ANY_TYPE = MediaType.builder().build();
    @NonNull
    private final String type;
    @NonNull
    private final String subtype;
    @NonNull
    private final Map<String, Collection<String>> parameters;

    @NonNull
    public static MediaType parse(@NonNull CharSequence text) throws IllegalArgumentException {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        String input = text.toString();
        if (MediaType.isEmptyOrTrimable(input)) {
            throw new IllegalArgumentException("Content is empty or trimable");
        }
        int subtypeIndex = input.indexOf(47);
        if (subtypeIndex == -1) {
            throw new IllegalArgumentException("Missing subtype");
        }
        String type = input.substring(0, subtypeIndex).toLowerCase(Locale.ROOT);
        if (MediaType.isEmptyOrTrimable(type)) {
            throw new IllegalArgumentException("Type is empty or trimable");
        }
        int paramsIndex = input.indexOf(59, subtypeIndex);
        String subType = input.substring(subtypeIndex + 1, paramsIndex != -1 ? paramsIndex : input.length()).toLowerCase(Locale.ROOT);
        if (MediaType.isEmptyOrTrimable(subType)) {
            throw new IllegalArgumentException("Subtype is empty or trimable");
        }
        if (paramsIndex == -1) {
            return new MediaType(type, subType, Collections.emptyMap());
        }
        HashMap<String, Collection> parameters = new HashMap<String, Collection>();
        for (String parameter : input.substring(paramsIndex + 1).split(";", -1)) {
            String[] keyValuePair = parameter.split("=", -1);
            if (keyValuePair.length != 2) {
                throw new IllegalArgumentException("Invalid key-value pair");
            }
            parameters.computeIfAbsent(MediaType.cleanParameter(keyValuePair[0]), o -> new ArrayList()).add(MediaType.cleanParameter(keyValuePair[1]));
        }
        return new MediaType(type, subType, Collections.unmodifiableMap(parameters));
    }

    public boolean isCompatible(@NonNull MediaType other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return !(!other.type.equals(WILDCARD) && !other.type.equals(this.type) || !other.subtype.equals(WILDCARD) && !other.subtype.equals(this.subtype) || !MediaType.containsAll(this.parameters, other.parameters));
    }

    public boolean isCompatibleWithoutParameters(@NonNull MediaType other) {
        if (other == null) {
            throw new NullPointerException("other is marked non-null but is null");
        }
        return !(!other.type.equals(WILDCARD) && !other.type.equals(this.type) || !other.subtype.equals(WILDCARD) && !other.subtype.equals(this.subtype));
    }

    @NonNull
    public Optional<Charset> getCharset() {
        Collection<String> charsets = this.parameters.get(CHARSET_PARAMETER);
        return charsets != null ? MediaType.findFirstCharset(charsets) : Optional.empty();
    }

    @NonNull
    public MediaType withCharset(@NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        HashMap<String, Collection<String>> result = new HashMap<String, Collection<String>>(this.parameters);
        result.put(CHARSET_PARAMETER, Collections.singletonList(charset.name()));
        return new MediaType(this.type, this.subtype, Collections.unmodifiableMap(result));
    }

    @NonNull
    public MediaType withoutParameters() {
        return this.parameters.isEmpty() ? this : new MediaType(this.type, this.subtype, Collections.emptyMap());
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append(this.type).append("/").append(this.subtype);
        this.parameters.forEach((k, v) -> v.forEach(o -> result.append("; ").append((String)k).append("=").append((String)o)));
        return result.toString();
    }

    private static boolean containsAll(Map<String, Collection<String>> l, Map<String, Collection<String>> r) {
        for (Map.Entry<String, Collection<String>> entry : r.entrySet()) {
            Collection<String> values = l.get(entry.getKey());
            if (values != null && values.containsAll(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static Optional<Charset> findFirstCharset(Collection<String> charsets) {
        return charsets.stream().map(Parser.onCharset()::parse).filter(Objects::nonNull).findFirst();
    }

    private static String cleanParameter(String input) {
        return input.toLowerCase(Locale.ROOT).trim();
    }

    private static boolean isEmptyOrTrimable(String o) {
        return o.isEmpty() || !o.trim().equals(o);
    }

    @Generated
    private static String $default$type() {
        return WILDCARD;
    }

    @Generated
    private static String $default$subtype() {
        return WILDCARD;
    }

    @Generated
    MediaType(@NonNull String type, @NonNull String subtype, @NonNull Map<String, Collection<String>> parameters) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (subtype == null) {
            throw new NullPointerException("subtype is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        this.type = type;
        this.subtype = subtype;
        this.parameters = parameters;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull Builder builder() {
        return new Builder();
    }

    @NonNull
    @Generated
    public String getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getSubtype() {
        return this.subtype;
    }

    @NonNull
    @Generated
    public Map<String, Collection<String>> getParameters() {
        return this.parameters;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MediaType)) {
            return false;
        }
        MediaType other = (MediaType)o;
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$subtype = this.getSubtype();
        String other$subtype = other.getSubtype();
        if (this$subtype == null ? other$subtype != null : !this$subtype.equals(other$subtype)) {
            return false;
        }
        Map<String, Collection<String>> this$parameters = this.getParameters();
        Map<String, Collection<String>> other$parameters = other.getParameters();
        return !(this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $subtype = this.getSubtype();
        result = result * 59 + ($subtype == null ? 43 : $subtype.hashCode());
        Map<String, Collection<String>> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 43 : ((Object)$parameters).hashCode());
        return result;
    }

    @Generated
    public static class Builder {
        @Generated
        private boolean type$set;
        @Generated
        private String type$value;
        @Generated
        private boolean subtype$set;
        @Generated
        private String subtype$value;
        @Generated
        private ArrayList<String> parameters$key;
        @Generated
        private ArrayList<Collection<String>> parameters$value;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type$value = type;
            this.type$set = true;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder subtype(@NonNull String subtype) {
            if (subtype == null) {
                throw new NullPointerException("subtype is marked non-null but is null");
            }
            this.subtype$value = subtype;
            this.subtype$set = true;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder parameter(String parameterKey, Collection<String> parameterValue) {
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            this.parameters$key.add(parameterKey);
            this.parameters$value.add(parameterValue);
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder parameters(@org.jspecify.annotations.NonNull Map<? extends String, ? extends Collection<String>> parameters) {
            if (parameters == null) {
                throw new NullPointerException("parameters cannot be null");
            }
            if (this.parameters$key == null) {
                this.parameters$key = new ArrayList();
                this.parameters$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Collection<String>> $lombokEntry : parameters.entrySet()) {
                this.parameters$key.add($lombokEntry.getKey());
                this.parameters$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder clearParameters() {
            if (this.parameters$key != null) {
                this.parameters$key.clear();
                this.parameters$value.clear();
            }
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull MediaType build() {
            Map<String, Collection<String>> parameters;
            switch (this.parameters$key == null ? 0 : this.parameters$key.size()) {
                case 0: {
                    parameters = Collections.emptyMap();
                    break;
                }
                case 1: {
                    parameters = Collections.singletonMap(this.parameters$key.get(0), this.parameters$value.get(0));
                    break;
                }
                default: {
                    parameters = new LinkedHashMap(this.parameters$key.size() < 0x40000000 ? 1 + this.parameters$key.size() + (this.parameters$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.parameters$key.size(); ++$i) {
                        parameters.put(this.parameters$key.get($i), this.parameters$value.get($i));
                    }
                    parameters = Collections.unmodifiableMap(parameters);
                }
            }
            String type$value = this.type$value;
            if (!this.type$set) {
                type$value = MediaType.$default$type();
            }
            String subtype$value = this.subtype$value;
            if (!this.subtype$set) {
                subtype$value = MediaType.$default$subtype();
            }
            return new MediaType(type$value, subtype$value, parameters);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "MediaType.Builder(type$value=" + this.type$value + ", subtype$value=" + this.subtype$value + ", parameters$key=" + this.parameters$key + ", parameters$value=" + this.parameters$value + ")";
        }
    }
}

